/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.concurrent.atomic.AtomicInteger;

public class NettyConnectionState {
    private final AtomicInteger usageCounter = new AtomicInteger();

    public boolean markInUse() {
        int current;
        do {
            if ((current = this.usageCounter.get()) != -1) continue;
            return false;
        } while (!this.usageCounter.compareAndSet(current, current + 1));
        return true;
    }

    public boolean release() {
        int next;
        int current;
        do {
            if ((current = this.usageCounter.get()) != -1) continue;
            return false;
        } while (!this.usageCounter.compareAndSet(current, next = current - 1));
        return next == -1;
    }

    public boolean forceRelease() {
        int previous = this.usageCounter.getAndSet(-1);
        return previous != -1;
    }
}

