/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.async.AsyncConnection;
import org.neo4j.driver.internal.async.pool.AsyncConnectionPool;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.v1.AccessMode;

public class DirectConnectionProvider
implements ConnectionProvider {
    private final BoltServerAddress address;
    private final ConnectionPool pool;
    private final AsyncConnectionPool asyncPool;

    DirectConnectionProvider(BoltServerAddress address, ConnectionPool pool, AsyncConnectionPool asyncPool) {
        this.address = address;
        this.pool = pool;
        this.asyncPool = asyncPool;
        this.verifyConnectivity();
    }

    @Override
    public PooledConnection acquireConnection(AccessMode mode) {
        return this.pool.acquire(this.address);
    }

    @Override
    public CompletionStage<AsyncConnection> acquireAsyncConnection(AccessMode mode) {
        return this.asyncPool.acquire(this.address);
    }

    @Override
    public CompletionStage<Void> close() {
        try {
            this.pool.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.asyncPool.close();
    }

    public BoltServerAddress getAddress() {
        return this.address;
    }

    private void verifyConnectivity() {
        this.acquireConnection(AccessMode.READ).close();
    }
}

