/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.driver.internal.messaging.MessageHandler;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.Neo4jException;

public class SocketResponseHandler
implements MessageHandler {
    private final Queue<ResponseHandler> handlers = new ConcurrentLinkedQueue<ResponseHandler>();
    private Neo4jException error;

    @Override
    public void handleRecordMessage(Value[] fields) {
        ResponseHandler handler = this.handlers.element();
        handler.onRecord(fields);
    }

    @Override
    public void handleFailureMessage(String code, String message) {
        ResponseHandler handler = this.handlers.remove();
        this.error = ErrorUtil.newNeo4jError(code, message);
        if (handler != null) {
            handler.onFailure(this.error);
        }
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        ResponseHandler handler = this.handlers.remove();
        handler.onSuccess(meta);
    }

    @Override
    public void handleIgnoredMessage() {
        ResponseHandler handler = this.handlers.remove();
        handler.onFailure(this.error);
    }

    @Override
    public void handleDiscardAllMessage() {
    }

    @Override
    public void handleResetMessage() {
    }

    @Override
    public void handleAckFailureMessage() {
    }

    @Override
    public void handlePullAllMessage() {
    }

    @Override
    public void handleInitMessage(String clientNameAndVersion, Map<String, Value> authToken) {
    }

    @Override
    public void handleRunMessage(String statement, Map<String, Value> parameters) {
    }

    public void appendResponseHandler(ResponseHandler handler) {
        Objects.requireNonNull(handler);
        this.handlers.add(handler);
    }

    public int handlersWaiting() {
        return this.handlers.size();
    }

    public boolean protocolViolationErrorOccurred() {
        return this.error != null && this.error.code().startsWith("Neo.ClientError.Request");
    }

    public boolean serverFailureOccurred() {
        return this.error != null;
    }

    public Neo4jException serverFailure() {
        return this.error;
    }

    public void clearError() {
        this.error = null;
    }
}

