/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.async.AsyncConnection;
import org.neo4j.driver.internal.async.Futures;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.summary.InternalNotification;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.internal.summary.InternalProfiledPlan;
import org.neo4j.driver.internal.summary.InternalResultSummary;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.summary.StatementType;

public abstract class PullAllResponseHandler
implements ResponseHandler {
    private static final boolean TOUCH_AUTO_READ = false;
    private final Statement statement;
    private final RunResponseHandler runResponseHandler;
    protected final AsyncConnection connection;
    private final Queue<Record> records = new LinkedList<Record>();
    private boolean succeeded;
    private Throwable failure;
    private ResultSummary summary;
    private CompletableFuture<Record> recordFuture;
    private CompletableFuture<ResultSummary> summaryFuture;

    public PullAllResponseHandler(Statement statement, RunResponseHandler runResponseHandler, AsyncConnection connection) {
        this.statement = Objects.requireNonNull(statement);
        this.runResponseHandler = Objects.requireNonNull(runResponseHandler);
        this.connection = Objects.requireNonNull(connection);
    }

    @Override
    public synchronized void onSuccess(Map<String, Value> metadata) {
        this.summary = this.extractResultSummary(metadata);
        if (this.summaryFuture != null) {
            this.summaryFuture.complete(this.summary);
            this.summaryFuture = null;
        }
        this.succeeded = true;
        this.afterSuccess();
        this.completeRecordFuture(null);
    }

    protected abstract void afterSuccess();

    @Override
    public synchronized void onFailure(Throwable error) {
        this.failure = error;
        this.afterFailure(error);
        this.failRecordFuture(error);
    }

    protected abstract void afterFailure(Throwable var1);

    @Override
    public synchronized void onRecord(Value[] fields) {
        InternalRecord record = new InternalRecord(this.runResponseHandler.statementKeys(), fields);
        if (this.recordFuture != null) {
            this.completeRecordFuture(record);
        } else {
            this.queueRecord(record);
        }
    }

    public synchronized CompletionStage<Record> nextAsync() {
        Record record = this.dequeueRecord();
        if (record == null) {
            if (this.succeeded) {
                return CompletableFuture.completedFuture(null);
            }
            if (this.failure != null) {
                return Futures.failedFuture(this.failure);
            }
            if (this.recordFuture == null) {
                this.recordFuture = new CompletableFuture();
            }
            return this.recordFuture;
        }
        return CompletableFuture.completedFuture(record);
    }

    public synchronized CompletionStage<ResultSummary> summaryAsync() {
        if (this.summary != null) {
            return CompletableFuture.completedFuture(this.summary);
        }
        if (this.summaryFuture == null) {
            this.summaryFuture = new CompletableFuture();
        }
        return this.summaryFuture;
    }

    private void queueRecord(Record record) {
        this.records.add(record);
    }

    private Record dequeueRecord() {
        Record record = this.records.poll();
        return record;
    }

    private void completeRecordFuture(Record record) {
        if (this.recordFuture != null) {
            CompletableFuture<Record> future = this.recordFuture;
            this.recordFuture = null;
            future.complete(record);
        }
    }

    private void failRecordFuture(Throwable error) {
        if (this.recordFuture != null) {
            CompletableFuture<Record> future = this.recordFuture;
            this.recordFuture = null;
            future.completeExceptionally(error);
        }
    }

    private ResultSummary extractResultSummary(Map<String, Value> metadata) {
        return new InternalResultSummary(this.statement, this.connection.serverInfo(), PullAllResponseHandler.extractStatementType(metadata), PullAllResponseHandler.extractCounters(metadata), PullAllResponseHandler.extractPlan(metadata), PullAllResponseHandler.extractProfiledPlan(metadata), PullAllResponseHandler.extractNotifications(metadata), this.runResponseHandler.resultAvailableAfter(), PullAllResponseHandler.extractResultConsumedAfter(metadata));
    }

    private static StatementType extractStatementType(Map<String, Value> metadata) {
        Value typeValue = metadata.get("type");
        if (typeValue != null) {
            return StatementType.fromCode(typeValue.asString());
        }
        return null;
    }

    private static InternalSummaryCounters extractCounters(Map<String, Value> metadata) {
        Value countersValue = metadata.get("stats");
        if (countersValue != null) {
            return new InternalSummaryCounters(PullAllResponseHandler.counterValue(countersValue, "nodes-created"), PullAllResponseHandler.counterValue(countersValue, "nodes-deleted"), PullAllResponseHandler.counterValue(countersValue, "relationships-created"), PullAllResponseHandler.counterValue(countersValue, "relationships-deleted"), PullAllResponseHandler.counterValue(countersValue, "properties-set"), PullAllResponseHandler.counterValue(countersValue, "labels-added"), PullAllResponseHandler.counterValue(countersValue, "labels-removed"), PullAllResponseHandler.counterValue(countersValue, "indexes-added"), PullAllResponseHandler.counterValue(countersValue, "indexes-removed"), PullAllResponseHandler.counterValue(countersValue, "constraints-added"), PullAllResponseHandler.counterValue(countersValue, "constraints-removed"));
        }
        return null;
    }

    private static int counterValue(Value countersValue, String name) {
        Value value = countersValue.get(name);
        return value.isNull() ? 0 : value.asInt();
    }

    private static Plan extractPlan(Map<String, Value> metadata) {
        Value planValue = metadata.get("plan");
        if (planValue != null) {
            return InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(planValue);
        }
        return null;
    }

    private static ProfiledPlan extractProfiledPlan(Map<String, Value> metadata) {
        Value profiledPlanValue = metadata.get("profile");
        if (profiledPlanValue != null) {
            return InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(profiledPlanValue);
        }
        return null;
    }

    private static List<Notification> extractNotifications(Map<String, Value> metadata) {
        Value notificationsValue = metadata.get("notifications");
        if (notificationsValue != null) {
            return notificationsValue.asList(InternalNotification.VALUE_TO_NOTIFICATION);
        }
        return Collections.emptyList();
    }

    private static long extractResultConsumedAfter(Map<String, Value> metadata) {
        Value resultConsumedAfterValue = metadata.get("result_consumed_after");
        if (resultConsumedAfterValue != null) {
            return resultConsumedAfterValue.asLong();
        }
        return -1L;
    }
}

