/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.Set;
import org.neo4j.driver.internal.net.BoltServerAddress;

public class AddressSet {
    private static final BoltServerAddress[] NONE = new BoltServerAddress[0];
    private volatile BoltServerAddress[] addresses = NONE;

    public BoltServerAddress[] toArray() {
        return this.addresses;
    }

    public int size() {
        return this.addresses.length;
    }

    public synchronized void update(Set<BoltServerAddress> addresses, Set<BoltServerAddress> removed) {
        BoltServerAddress[] prev = this.addresses;
        if (addresses.isEmpty()) {
            this.addresses = NONE;
            return;
        }
        if (prev.length == 0) {
            this.addresses = addresses.toArray(NONE);
            return;
        }
        BoltServerAddress[] copy = null;
        if (addresses.size() != prev.length) {
            copy = new BoltServerAddress[addresses.size()];
        }
        int j = 0;
        for (int i = 0; i < prev.length; ++i) {
            if (addresses.remove(prev[i])) {
                if (copy == null) continue;
                copy[j++] = prev[i];
                continue;
            }
            removed.add(prev[i]);
            if (copy != null) continue;
            copy = new BoltServerAddress[prev.length];
            System.arraycopy(prev, 0, copy, 0, i);
            j = i;
        }
        if (copy == null) {
            return;
        }
        for (BoltServerAddress address : addresses) {
            copy[j++] = address;
        }
        this.addresses = copy;
    }

    public synchronized void remove(BoltServerAddress address) {
        BoltServerAddress[] addresses = this.addresses;
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                if (!addresses[i].equals(address)) continue;
                if (addresses.length == 1) {
                    this.addresses = NONE;
                    return;
                }
                BoltServerAddress[] copy = new BoltServerAddress[addresses.length - 1];
                System.arraycopy(addresses, 0, copy, 0, i);
                System.arraycopy(addresses, i + 1, copy, i, addresses.length - i - 1);
                this.addresses = copy;
                return;
            }
        }
    }

    public String toString() {
        return "AddressSet=" + Arrays.toString(this.addresses);
    }
}

