/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelPool;
import io.netty.util.concurrent.Promise;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.async.AsyncConnection;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.Futures;
import org.neo4j.driver.internal.async.NettyConnectionState;
import org.neo4j.driver.internal.async.ReleaseChannelHandler;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.PullAllMessage;
import org.neo4j.driver.internal.messaging.ResetMessage;
import org.neo4j.driver.internal.messaging.RunMessage;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.summary.InternalServerInfo;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.ServerInfo;

public class NettyConnection
implements AsyncConnection {
    private final Channel channel;
    private final InboundMessageDispatcher messageDispatcher;
    private final ChannelPool channelPool;
    private final Clock clock;
    private final AtomicBoolean autoReadEnabled = new AtomicBoolean(true);
    private final NettyConnectionState state = new NettyConnectionState();

    public NettyConnection(Channel channel, ChannelPool channelPool, Clock clock) {
        this.channel = channel;
        this.messageDispatcher = ChannelAttributes.messageDispatcher(channel);
        this.channelPool = channelPool;
        this.clock = clock;
    }

    @Override
    public boolean tryMarkInUse() {
        return this.state.markInUse();
    }

    @Override
    public void enableAutoRead() {
        if (this.autoReadEnabled.compareAndSet(false, true)) {
            this.setAutoRead(true);
        }
    }

    @Override
    public void disableAutoRead() {
        if (this.autoReadEnabled.compareAndSet(true, false)) {
            this.setAutoRead(false);
        }
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, ResponseHandler runHandler, ResponseHandler pullAllHandler) {
        this.run(statement, parameters, runHandler, pullAllHandler, false);
    }

    @Override
    public void runAndFlush(String statement, Map<String, Value> parameters, ResponseHandler runHandler, ResponseHandler pullAllHandler) {
        this.run(statement, parameters, runHandler, pullAllHandler, true);
    }

    @Override
    public void release() {
        if (this.state.release()) {
            this.reset(new ReleaseChannelHandler(this.channel, this.channelPool, this.clock));
        }
    }

    @Override
    public CompletionStage<Void> forceRelease() {
        if (this.state.forceRelease()) {
            Promise releasePromise = this.channel.eventLoop().newPromise();
            this.reset(new ReleaseChannelHandler(this.channel, this.channelPool, this.clock, (Promise<Void>)releasePromise));
            return Futures.asCompletionStage(releasePromise);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public ServerInfo serverInfo() {
        return new InternalServerInfo(ChannelAttributes.address(this.channel), ChannelAttributes.serverVersion(this.channel));
    }

    private void run(String statement, Map<String, Value> parameters, ResponseHandler runHandler, ResponseHandler pullAllHandler, boolean flush) {
        this.writeMessagesInEventLoop(new RunMessage(statement, parameters), runHandler, PullAllMessage.PULL_ALL, pullAllHandler, flush);
    }

    private void reset(ResponseHandler resetHandler) {
        this.writeAndFlushMessageInEventLoop(ResetMessage.RESET, resetHandler);
    }

    private void writeMessagesInEventLoop(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2, boolean flush) {
        EventLoop eventLoop = this.channel.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.writeMessages(message1, handler1, message2, handler2, flush);
        } else {
            eventLoop.execute(() -> this.writeMessages(message1, handler1, message2, handler2, flush));
        }
    }

    private void writeAndFlushMessageInEventLoop(Message message, ResponseHandler handler) {
        EventLoop eventLoop = this.channel.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.writeAndFlushMessage(message, handler);
        } else {
            eventLoop.execute(() -> this.writeAndFlushMessage(message, handler));
        }
    }

    private void writeMessages(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2, boolean flush) {
        this.messageDispatcher.queue(handler1);
        this.messageDispatcher.queue(handler2);
        this.channel.write((Object)message1);
        if (flush) {
            this.channel.writeAndFlush((Object)message2);
        } else {
            this.channel.write((Object)message2);
        }
    }

    private void writeAndFlushMessage(Message message, ResponseHandler handler) {
        this.messageDispatcher.queue(handler);
        this.channel.writeAndFlush((Object)message);
    }

    private void setAutoRead(boolean value) {
        this.channel.config().setAutoRead(value);
    }
}

