/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.Clock;

public class NettyChannelInitializer
extends ChannelInitializer<Channel> {
    private final BoltServerAddress address;
    private final SecurityPlan securityPlan;
    private final ChannelPoolHandler channelPoolHandler;
    private final Clock clock;

    public NettyChannelInitializer(BoltServerAddress address, SecurityPlan securityPlan, ChannelPoolHandler channelPoolHandler, Clock clock) {
        this.address = address;
        this.securityPlan = securityPlan;
        this.channelPoolHandler = channelPoolHandler;
        this.clock = clock;
    }

    protected void initChannel(Channel channel) throws Exception {
        if (this.securityPlan.requiresEncryption()) {
            SslHandler sslHandler = this.createSslHandler();
            channel.pipeline().addFirst(new ChannelHandler[]{sslHandler});
        }
        this.updateChannelAttributes(channel);
        this.channelPoolHandler.channelCreated(channel);
    }

    private SslHandler createSslHandler() {
        SSLEngine sslEngine = this.createSslEngine();
        return new SslHandler(sslEngine);
    }

    private SSLEngine createSslEngine() {
        SSLContext sslContext = this.securityPlan.sslContext();
        SSLEngine sslEngine = sslContext.createSSLEngine(this.address.host(), this.address.port());
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }

    private void updateChannelAttributes(Channel channel) {
        ChannelAttributes.setAddress(channel, this.address);
        ChannelAttributes.setCreationTimestamp(channel, this.clock.millis());
        ChannelAttributes.setMessageDispatcher(channel, new InboundMessageDispatcher(channel, DevNullLogging.DEV_NULL_LOGGING));
    }
}

