/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.net.BoltServerAddress;

public final class ChannelAttributes {
    private static final AttributeKey<BoltServerAddress> ADDRESS = AttributeKey.newInstance((String)"address");
    private static final AttributeKey<Long> CREATION_TIMESTAMP = AttributeKey.newInstance((String)"creationTimestamp");
    private static final AttributeKey<Long> LAST_USED_TIMESTAMP = AttributeKey.newInstance((String)"lastUsedTimestamp");
    private static final AttributeKey<InboundMessageDispatcher> MESSAGE_DISPATCHER = AttributeKey.newInstance((String)"messageDispatcher");
    private static final AttributeKey<String> SERVER_VERSION = AttributeKey.newInstance((String)"serverVersion");

    private ChannelAttributes() {
    }

    public static BoltServerAddress address(Channel channel) {
        return ChannelAttributes.get(channel, ADDRESS);
    }

    public static void setAddress(Channel channel, BoltServerAddress address) {
        ChannelAttributes.setOnce(channel, ADDRESS, address);
    }

    public static long creationTimestamp(Channel channel) {
        return ChannelAttributes.get(channel, CREATION_TIMESTAMP);
    }

    public static void setCreationTimestamp(Channel channel, long creationTimestamp) {
        ChannelAttributes.setOnce(channel, CREATION_TIMESTAMP, creationTimestamp);
    }

    public static Long lastUsedTimestamp(Channel channel) {
        return ChannelAttributes.get(channel, LAST_USED_TIMESTAMP);
    }

    public static void setLastUsedTimestamp(Channel channel, long lastUsedTimestamp) {
        ChannelAttributes.set(channel, LAST_USED_TIMESTAMP, lastUsedTimestamp);
    }

    public static InboundMessageDispatcher messageDispatcher(Channel channel) {
        return ChannelAttributes.get(channel, MESSAGE_DISPATCHER);
    }

    public static void setMessageDispatcher(Channel channel, InboundMessageDispatcher messageDispatcher) {
        ChannelAttributes.setOnce(channel, MESSAGE_DISPATCHER, messageDispatcher);
    }

    public static String serverVersion(Channel channel) {
        return ChannelAttributes.get(channel, SERVER_VERSION);
    }

    public static void setServerVersion(Channel channel, String serverVersion) {
        ChannelAttributes.setOnce(channel, SERVER_VERSION, serverVersion);
    }

    private static <T> T get(Channel channel, AttributeKey<T> key) {
        return (T)channel.attr(key).get();
    }

    private static <T> void set(Channel channel, AttributeKey<T> key, T value) {
        channel.attr(key).set(value);
    }

    private static <T> void setOnce(Channel channel, AttributeKey<T> key, T value) {
        Object existingValue = channel.attr(key).setIfAbsent(value);
        if (existingValue != null) {
            throw new IllegalStateException("Unable to set " + key.name() + " because it is already set to " + existingValue);
        }
    }
}

