/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.driver.ResultResourcesHandler;
import org.neo4j.driver.internal.handlers.RecordsResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.summary.InternalResultSummary;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.util.Function;
import org.neo4j.driver.v1.util.Functions;

public class InternalStatementResult
implements StatementResult {
    private final Statement statement;
    private final Connection connection;
    private final ResultResourcesHandler resourcesHandler;
    private final RunResponseHandler runResponseHandler;
    private final RecordsResponseHandler pullAllResponseHandler;

    InternalStatementResult(Statement statement, Connection connection, ResultResourcesHandler resourcesHandler) {
        this.statement = statement;
        this.connection = connection;
        this.runResponseHandler = new RunResponseHandler(null, null);
        this.pullAllResponseHandler = new RecordsResponseHandler(this.runResponseHandler);
        this.resourcesHandler = resourcesHandler;
    }

    ResponseHandler runResponseHandler() {
        return this.runResponseHandler;
    }

    ResponseHandler pullAllResponseHandler() {
        return this.pullAllResponseHandler;
    }

    @Override
    public List<String> keys() {
        if (this.runResponseHandler.statementKeys() == null) {
            this.tryFetchNext();
        }
        return this.runResponseHandler.statementKeys();
    }

    @Override
    public boolean hasNext() {
        return this.tryFetchNext();
    }

    @Override
    public Record next() {
        if (this.tryFetchNext()) {
            return this.pullAllResponseHandler.recordBuffer().poll();
        }
        throw new NoSuchRecordException("No more records");
    }

    @Override
    public Record single() {
        if (this.hasNext()) {
            Record single = this.next();
            boolean hasMoreThanOne = this.hasNext();
            this.consume();
            if (hasMoreThanOne) {
                throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record, or use `first` instead of `single` if you do not care about the number of records in the result.");
            }
            return single;
        }
        throw new NoSuchRecordException("Cannot retrieve a single record, because this result is empty.");
    }

    @Override
    public Record peek() {
        if (this.tryFetchNext()) {
            return this.pullAllResponseHandler.recordBuffer().peek();
        }
        throw new NoSuchRecordException("Cannot peek past the last record");
    }

    @Override
    public List<Record> list() {
        return this.list(Functions.identity());
    }

    @Override
    public <T> List<T> list(Function<Record, T> mapFunction) {
        if (this.hasNext()) {
            ArrayList<T> result = new ArrayList<T>();
            do {
                result.add(mapFunction.apply(this.next()));
            } while (this.hasNext());
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public ResultSummary consume() {
        if (this.pullAllResponseHandler.isCompleted()) {
            this.pullAllResponseHandler.recordBuffer().clear();
        } else {
            do {
                this.receiveOne();
                this.pullAllResponseHandler.recordBuffer().clear();
            } while (!this.pullAllResponseHandler.isCompleted());
        }
        return this.createResultSummary();
    }

    @Override
    public ResultSummary summary() {
        while (!this.pullAllResponseHandler.isCompleted()) {
            this.receiveOne();
        }
        return this.createResultSummary();
    }

    @Override
    public void remove() {
        throw new ClientException("Removing records from a result is not supported.");
    }

    private boolean tryFetchNext() {
        while (this.pullAllResponseHandler.recordBuffer().isEmpty()) {
            if (this.pullAllResponseHandler.isCompleted()) {
                return false;
            }
            this.receiveOne();
        }
        return true;
    }

    private void receiveOne() {
        try {
            this.connection.receiveOne();
        }
        catch (Throwable error) {
            this.resourcesHandler.resultFailed(error);
            throw error;
        }
        if (this.pullAllResponseHandler.isCompleted()) {
            this.resourcesHandler.resultFetched();
        }
    }

    private ResultSummary createResultSummary() {
        return new InternalResultSummary(this.statement, this.connection.server(), this.pullAllResponseHandler.statementType(), this.pullAllResponseHandler.counters(), this.pullAllResponseHandler.plan(), this.pullAllResponseHandler.profile(), this.pullAllResponseHandler.notifications(), this.runResponseHandler.resultAvailableAfter(), this.pullAllResponseHandler.resultConsumedAfter());
    }
}

