/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.util.Queue;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.ChannelFactory;
import org.neo4j.driver.internal.net.SocketProtocol;
import org.neo4j.driver.internal.net.SocketProtocolV1;
import org.neo4j.driver.internal.net.SocketResponseHandler;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.BytePrinter;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class SocketClient {
    private static final int MAGIC_PREAMBLE = 1616949271;
    private static final int VERSION1 = 1;
    private static final int HTTP = 1213486160;
    private static final int NO_VERSION = 0;
    private static final int[] SUPPORTED_VERSIONS = new int[]{1, 0, 0, 0};
    private final BoltServerAddress address;
    private final SecurityPlan securityPlan;
    private final int timeoutMillis;
    private final Logger logger;
    private SocketProtocol protocol;
    private MessageFormat.Reader reader;
    private MessageFormat.Writer writer;
    private ByteChannel channel;

    public SocketClient(BoltServerAddress address, SecurityPlan securityPlan, int timeoutMillis, Logger logger) {
        this.address = address;
        this.securityPlan = securityPlan;
        this.timeoutMillis = timeoutMillis;
        this.logger = logger;
        this.channel = null;
    }

    void setChannel(ByteChannel channel) {
        this.channel = channel;
    }

    void blockingRead(ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            if (this.channel.read(buf) >= 0) continue;
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String bufStr = BytePrinter.hex(buf).trim();
            throw new ServiceUnavailableException(String.format("Connection terminated while receiving data. This can happen due to network instabilities, or due to restarts of the database. Expected %s bytes, received %s.", buf.limit(), bufStr.isEmpty() ? "none" : bufStr));
        }
    }

    void blockingWrite(ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            if (this.channel.write(buf) >= 0) continue;
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String bufStr = BytePrinter.hex(buf).trim();
            throw new ServiceUnavailableException(String.format("Connection terminated while sending data. This can happen due to network instabilities, or due to restarts of the database. Expected %s bytes, wrote %s.", buf.limit(), bufStr.isEmpty() ? "none" : bufStr));
        }
    }

    public void start() {
        try {
            this.logger.debug("~~ [CONNECT] %s", this.address);
            if (this.channel == null) {
                this.setChannel(ChannelFactory.create(this.address, this.securityPlan, this.timeoutMillis, this.logger));
            }
            this.protocol = this.negotiateProtocol();
            this.reader = this.protocol.reader();
            this.writer = this.protocol.writer();
        }
        catch (ConnectException e) {
            throw new ServiceUnavailableException(String.format("Unable to connect to %s, ensure the database is running and that there is a working network connection to it.", this.address), e);
        }
        catch (IOException e) {
            throw new ServiceUnavailableException("Unable to process request: " + e.getMessage(), e);
        }
    }

    public void send(Queue<Message> messages) throws IOException {
        Message message;
        int messageCount = 0;
        while ((message = messages.poll()) != null) {
            this.logger.debug("C: %s", message);
            this.writer.write(message);
            ++messageCount;
        }
        if (messageCount > 0) {
            this.writer.flush();
        }
    }

    public void receiveAll(SocketResponseHandler handler) throws IOException {
        while (handler.collectorsWaiting() > 0) {
            this.receiveOne(handler);
        }
    }

    public void receiveOne(SocketResponseHandler handler) throws IOException {
        this.reader.read(handler);
        if (handler.protocolViolationErrorOccurred()) {
            this.stop();
            throw handler.serverFailure();
        }
    }

    public void stop() {
        block3: {
            try {
                if (this.channel != null) {
                    this.channel.close();
                    this.setChannel(null);
                    this.logger.debug("~~ [DISCONNECT]", new Object[0]);
                }
            }
            catch (IOException e) {
                if (e.getMessage().equals("An existing connection was forcibly closed by the remote host")) break block3;
                this.logger.error("Unable to close socket connection properly", e);
            }
        }
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    private SocketProtocol negotiateProtocol() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(20).order(ByteOrder.BIG_ENDIAN);
        this.logger.debug("C: [HANDSHAKE] 0x6060B017", new Object[0]);
        buf.putInt(1616949271);
        this.logger.debug("C: [HANDSHAKE] [1, 0, 0, 0]", new Object[0]);
        for (int version : SUPPORTED_VERSIONS) {
            buf.putInt(version);
        }
        buf.flip();
        this.blockingWrite(buf);
        buf.clear();
        buf.limit(4);
        try {
            this.blockingRead(buf);
        }
        catch (ClientException e) {
            if (buf.position() == 0) {
                throw new ClientException(String.format("Failed to establish connection with server. Make sure that you have a server with bolt enabled on %s", this.address));
            }
            throw e;
        }
        buf.flip();
        int proposal = buf.getInt();
        switch (proposal) {
            case 1: {
                this.logger.debug("S: [HANDSHAKE] -> 1", new Object[0]);
                return new SocketProtocolV1(this.channel);
            }
            case 0: {
                throw new ClientException("The server does not support any of the protocol versions supported by this driver. Ensure that you are using driver and server versions that are compatible with one another.");
            }
            case 1213486160: {
                throw new ClientException("Server responded HTTP. Make sure you are not trying to connect to the http endpoint (HTTP defaults to port 7474 whereas BOLT defaults to port 7687)");
            }
        }
        throw new ClientException("Protocol error, server suggested unexpected protocol version: " + proposal);
    }

    public String toString() {
        int version = this.protocol == null ? -1 : this.protocol.version();
        return "SocketClient[protocolVersion=" + version + "]";
    }

    public BoltServerAddress address() {
        return this.address;
    }
}

