/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.ClusterCompositionResponse;
import org.neo4j.driver.internal.cluster.GetServersProcedureRunner;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ProtocolException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.value.ValueException;

public class GetServersProcedureClusterCompositionProvider
implements ClusterCompositionProvider {
    private final String PROTOCOL_ERROR_MESSAGE = "Failed to parse `%s' result received from server due to ";
    private final Clock clock;
    private final Logger log;
    private final GetServersProcedureRunner getServersRunner;

    public GetServersProcedureClusterCompositionProvider(Clock clock, Logger log, RoutingSettings settings) {
        this(clock, log, new GetServersProcedureRunner(settings.routingParameters));
    }

    GetServersProcedureClusterCompositionProvider(Clock clock, Logger log, GetServersProcedureRunner getServersRunner) {
        this.clock = clock;
        this.log = log;
        this.getServersRunner = getServersRunner;
    }

    @Override
    public ClusterCompositionResponse getClusterComposition(Connection connection) {
        ClusterComposition cluster;
        List<Record> records;
        try {
            records = this.getServersRunner.run(connection);
        }
        catch (ClientException e) {
            return new ClusterCompositionResponse.Failure(new ServiceUnavailableException(String.format("Failed to run '%s' on server. Please make sure that there is a Neo4j 3.1+ causal cluster up running.", this.getServersRunner.procedureCalled()), e));
        }
        this.log.info("Got getServers response: %s", records);
        long now = this.clock.millis();
        if (records.size() != 1) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse `%s' result received from server due to records received '%s' is too few or too many.", this.getServersRunner.procedureCalled(), records.size())));
        }
        try {
            cluster = ClusterComposition.parse(records.get(0), now);
        }
        catch (ValueException e) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse `%s' result received from server due to unparsable record received.", this.getServersRunner.procedureCalled()), e));
        }
        if (!cluster.hasRoutersAndReaders()) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse `%s' result received from server due to no router or reader found in response.", this.getServersRunner.procedureCalled())));
        }
        return new ClusterCompositionResponse.Success(cluster);
    }
}

