/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

public class PoolSettings {
    public static final int NO_IDLE_CONNECTION_TEST = -1;
    public static final int DEFAULT_MAX_IDLE_CONNECTION_POOL_SIZE = 10;
    public static final int DEFAULT_IDLE_TIME_BEFORE_CONNECTION_TEST = -1;
    private final int maxIdleConnectionPoolSize;
    private final long idleTimeBeforeConnectionTest;

    public PoolSettings(int maxIdleConnectionPoolSize, long idleTimeBeforeConnectionTest) {
        this.maxIdleConnectionPoolSize = maxIdleConnectionPoolSize;
        this.idleTimeBeforeConnectionTest = idleTimeBeforeConnectionTest;
    }

    public int maxIdleConnectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public long idleTimeBeforeConnectionTest() {
        if (!this.idleTimeBeforeConnectionTestConfigured()) {
            throw new IllegalStateException("Idle time before connection test is not configured: " + this.idleTimeBeforeConnectionTest);
        }
        return this.idleTimeBeforeConnectionTest;
    }

    public boolean idleTimeBeforeConnectionTestConfigured() {
        return this.idleTimeBeforeConnectionTest >= 0L;
    }
}

