/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.ClusterCompositionResponse;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.exceptions.SecurityException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class Rediscovery {
    private static final String NO_ROUTERS_AVAILABLE = "Could not perform discovery. No routing servers available.";
    private final RoutingSettings settings;
    private final Clock clock;
    private final Logger logger;
    private final ClusterCompositionProvider provider;

    public Rediscovery(RoutingSettings settings, Clock clock, Logger logger, ClusterCompositionProvider provider) {
        this.settings = settings;
        this.clock = clock;
        this.logger = logger;
        this.provider = provider;
    }

    public ClusterComposition lookupRoutingTable(ConnectionPool connections, RoutingTable routingTable) throws InterruptedException {
        this.assertHasRouters(routingTable);
        int failures = 0;
        long start = this.clock.millis();
        long delay = 0L;
        while (true) {
            long waitTime;
            if ((waitTime = start + delay - this.clock.millis()) > 0L) {
                this.clock.sleep(waitTime);
            }
            start = this.clock.millis();
            int size = routingTable.routerSize();
            for (int i = 0; i < size; ++i) {
                BoltServerAddress address = routingTable.nextRouter();
                if (address == null) {
                    throw new ServiceUnavailableException(NO_ROUTERS_AVAILABLE);
                }
                ClusterCompositionResponse response = null;
                try (Connection connection = connections.acquire(address);){
                    response = this.provider.getClusterComposition(connection);
                }
                catch (SecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error(String.format("Failed to connect to routing server '%s'.", address), e);
                    routingTable.removeRouter(address);
                    this.assertHasRouters(routingTable);
                    continue;
                }
                ClusterComposition cluster = response.clusterComposition();
                this.logger.info("Got cluster composition %s", cluster);
                if (!cluster.hasWriters()) continue;
                return cluster;
            }
            if (++failures >= this.settings.maxRoutingFailures) {
                throw new ServiceUnavailableException(NO_ROUTERS_AVAILABLE);
            }
            delay = Math.max(this.settings.retryTimeoutDelay, delay * 2L);
        }
    }

    private void assertHasRouters(RoutingTable table) {
        if (table.routerSize() == 0) {
            throw new ServiceUnavailableException(NO_ROUTERS_AVAILABLE);
        }
    }
}

