/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.util.Function;

final class ClusterComposition {
    private static final long MAX_TTL = 9223372036854775L;
    private static final Function<Value, BoltServerAddress> OF_BoltServerAddress = new Function<Value, BoltServerAddress>(){

        @Override
        public BoltServerAddress apply(Value value) {
            return new BoltServerAddress(value.asString());
        }
    };
    private final Set<BoltServerAddress> readers = new HashSet<BoltServerAddress>();
    private final Set<BoltServerAddress> writers = new HashSet<BoltServerAddress>();
    private final Set<BoltServerAddress> routers = new HashSet<BoltServerAddress>();
    private final long expirationTimestamp;

    private ClusterComposition(long expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
    }

    ClusterComposition(long expirationTimestamp, Set<BoltServerAddress> readers, Set<BoltServerAddress> writers, Set<BoltServerAddress> routers) {
        this(expirationTimestamp);
        this.readers.addAll(readers);
        this.writers.addAll(writers);
        this.routers.addAll(routers);
    }

    public boolean hasWriters() {
        return !this.writers.isEmpty();
    }

    public boolean hasRoutersAndReaders() {
        return this.routers.isEmpty() || this.readers.isEmpty();
    }

    public Set<BoltServerAddress> readers() {
        return new HashSet<BoltServerAddress>(this.readers);
    }

    public Set<BoltServerAddress> writers() {
        return new HashSet<BoltServerAddress>(this.writers);
    }

    public Set<BoltServerAddress> routers() {
        return new HashSet<BoltServerAddress>(this.routers);
    }

    public long expirationTimestamp() {
        return this.expirationTimestamp;
    }

    public String toString() {
        return "ClusterComposition{expirationTimestamp=" + this.expirationTimestamp + ", readers=" + this.readers + ", writers=" + this.writers + ", routers=" + this.routers + '}';
    }

    public static ClusterComposition parse(Record record, long now) {
        if (record == null) {
            return null;
        }
        final ClusterComposition result = new ClusterComposition(ClusterComposition.expirationTimestamp(now, record));
        record.get("servers").asList(new Function<Value, Void>(){

            @Override
            public Void apply(Value value) {
                result.servers(value.get("role").asString()).addAll(value.get("addresses").asList(OF_BoltServerAddress));
                return null;
            }
        });
        return result;
    }

    private static long expirationTimestamp(long now, Record record) {
        long ttl = record.get("ttl").asLong();
        long expirationTimestamp = now + ttl * 1000L;
        if (ttl < 0L || ttl >= 9223372036854775L || expirationTimestamp < 0L) {
            expirationTimestamp = Long.MAX_VALUE;
        }
        return expirationTimestamp;
    }

    private Set<BoltServerAddress> servers(String role) {
        switch (role) {
            case "READ": {
                return this.readers;
            }
            case "WRITE": {
                return this.writers;
            }
            case "ROUTE": {
                return this.routers;
            }
        }
        throw new IllegalArgumentException("invalid server role: " + role);
    }
}

