/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.ConcurrencyGuardingConnection;
import org.neo4j.driver.internal.net.SocketConnection;
import org.neo4j.driver.internal.net.pooling.BlockingPooledConnectionQueue;
import org.neo4j.driver.internal.net.pooling.PoolSettings;
import org.neo4j.driver.internal.net.pooling.PooledConnection;
import org.neo4j.driver.internal.net.pooling.PooledConnectionReleaseConsumer;
import org.neo4j.driver.internal.net.pooling.PooledConnectionValidator;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Supplier;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class SocketConnectionPool
implements ConnectionPool {
    private final ConcurrentHashMap<BoltServerAddress, BlockingPooledConnectionQueue> pools = new ConcurrentHashMap();
    private final Clock clock = Clock.SYSTEM;
    private final ConnectionSettings connectionSettings;
    private final SecurityPlan securityPlan;
    private final PoolSettings poolSettings;
    private final Logging logging;

    public SocketConnectionPool(ConnectionSettings connectionSettings, SecurityPlan securityPlan, PoolSettings poolSettings, Logging logging) {
        this.connectionSettings = connectionSettings;
        this.securityPlan = securityPlan;
        this.poolSettings = poolSettings;
        this.logging = logging;
    }

    private Connection connect(BoltServerAddress address) throws ClientException {
        Connection conn = new SocketConnection(address, this.securityPlan, this.logging);
        conn = new ConcurrencyGuardingConnection(conn);
        conn.init(this.connectionSettings.userAgent(), SocketConnectionPool.tokenAsMap(this.connectionSettings.authToken()));
        return conn;
    }

    private static Map<String, Value> tokenAsMap(AuthToken token) {
        if (token instanceof InternalAuthToken) {
            return ((InternalAuthToken)token).toMap();
        }
        throw new ClientException("Unknown authentication token, `" + token + "`. Please use one of the supported " + "tokens from `" + AuthTokens.class.getSimpleName() + "`.");
    }

    @Override
    public Connection acquire(final BoltServerAddress address) {
        final BlockingPooledConnectionQueue connections = this.pool(address);
        Supplier<PooledConnection> supplier = new Supplier<PooledConnection>(){

            @Override
            public PooledConnection get() {
                PooledConnectionValidator connectionValidator = new PooledConnectionValidator(SocketConnectionPool.this);
                PooledConnectionReleaseConsumer releaseConsumer = new PooledConnectionReleaseConsumer(connections, connectionValidator);
                return new PooledConnection(SocketConnectionPool.this.connect(address), releaseConsumer, SocketConnectionPool.this.clock);
            }
        };
        PooledConnection conn = connections.acquire(supplier);
        conn.updateTimestamp();
        return conn;
    }

    private BlockingPooledConnectionQueue pool(BoltServerAddress address) {
        BlockingPooledConnectionQueue pool = this.pools.get(address);
        if (pool == null && this.pools.putIfAbsent(address, pool = new BlockingPooledConnectionQueue(this.poolSettings.maxIdleConnectionPoolSize())) != null) {
            return this.pool(address);
        }
        return pool;
    }

    @Override
    public void purge(BoltServerAddress address) {
        BlockingPooledConnectionQueue connections = this.pools.remove(address);
        if (connections == null) {
            return;
        }
        connections.terminate();
    }

    @Override
    public boolean hasAddress(BoltServerAddress address) {
        return this.pools.containsKey(address);
    }

    @Override
    public void close() {
        for (BlockingPooledConnectionQueue pool : this.pools.values()) {
            pool.terminate();
        }
        this.pools.clear();
    }

    public List<PooledConnection> connectionsForAddress(BoltServerAddress address) {
        BlockingPooledConnectionQueue pooledConnections = this.pools.get(address);
        if (pooledConnections == null) {
            return Collections.emptyList();
        }
        return pooledConnections.toList();
    }
}

