/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Collector;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.summary.ServerInfo;

public class ConcurrencyGuardingConnection
implements Connection {
    private final Connection delegate;
    private final AtomicBoolean inUse = new AtomicBoolean(false);

    public ConcurrencyGuardingConnection(Connection delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String clientName, Map<String, Value> authToken) {
        try {
            this.markAsInUse();
            this.delegate.init(clientName, authToken);
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String statement, Map<String, Value> parameters, Collector collector) {
        try {
            this.markAsInUse();
            this.delegate.run(statement, parameters, collector);
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardAll(Collector collector) {
        try {
            this.markAsInUse();
            this.delegate.discardAll(collector);
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullAll(Collector collector) {
        try {
            this.markAsInUse();
            this.delegate.pullAll(collector);
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        try {
            this.markAsInUse();
            this.delegate.reset();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ackFailure() {
        try {
            this.markAsInUse();
            this.delegate.ackFailure();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        try {
            this.markAsInUse();
            this.delegate.sync();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            this.markAsInUse();
            this.delegate.flush();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveOne() {
        try {
            this.markAsInUse();
            this.delegate.receiveOne();
        }
        finally {
            this.markAsAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.markAsInUse();
            this.delegate.close();
        }
        finally {
            this.markAsAvailable();
        }
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void onError(Runnable runnable) {
        this.delegate.onError(runnable);
    }

    @Override
    public boolean hasUnrecoverableErrors() {
        return this.delegate.hasUnrecoverableErrors();
    }

    @Override
    public void resetAsync() {
        this.delegate.resetAsync();
    }

    @Override
    public boolean isAckFailureMuted() {
        return this.delegate.isAckFailureMuted();
    }

    private void markAsAvailable() {
        this.inUse.set(false);
    }

    private void markAsInUse() {
        if (!this.inUse.compareAndSet(false, true)) {
            throw new ClientException("You are using a session from multiple locations at the same time, which is not supported. If you want to use multiple threads, you should ensure that each session is used by only one thread at a time. One way to do that is to give each thread its own dedicated session.");
        }
    }

    @Override
    public ServerInfo server() {
        return this.delegate.server();
    }

    @Override
    public BoltServerAddress boltServerAddress() {
        return this.delegate.boltServerAddress();
    }

    @Override
    public Logger logger() {
        return this.delegate.logger();
    }
}

