/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.BaseDriver;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.RoutingNetworkSession;
import org.neo4j.driver.internal.cluster.LoadBalancer;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.exceptions.ClientException;

public class RoutingDriver
extends BaseDriver {
    private final LoadBalancer loadBalancer;

    private static SecurityPlan verifiedSecurityPlan(SecurityPlan securityPlan) {
        if (!securityPlan.isRoutingCompatible()) {
            throw new IllegalArgumentException("The chosen security plan is not compatible with a routing driver");
        }
        return securityPlan;
    }

    public RoutingDriver(RoutingSettings settings, BoltServerAddress seedAddress, ConnectionPool connections, SecurityPlan securityPlan, Clock clock, Logging logging) {
        super(RoutingDriver.verifiedSecurityPlan(securityPlan), logging);
        this.loadBalancer = new LoadBalancer(settings, clock, this.log, connections, seedAddress);
    }

    @Override
    protected Session newSessionWithMode(AccessMode mode) {
        Connection connection = this.acquireConnection(mode);
        NetworkSession networkSession = new NetworkSession(connection);
        return new RoutingNetworkSession(networkSession, mode, connection.boltServerAddress(), this.loadBalancer);
    }

    private Connection acquireConnection(AccessMode role) {
        switch (role) {
            case READ: {
                return this.loadBalancer.acquireReadConnection();
            }
            case WRITE: {
                return this.loadBalancer.acquireWriteConnection();
            }
        }
        throw new ClientException((Object)((Object)role) + " is not supported for creating new sessions");
    }

    @Override
    protected void closeResources() {
        try {
            this.loadBalancer.close();
        }
        catch (Exception ex) {
            this.log.error(String.format("~~ [ERROR] %s", ex.getMessage()), ex);
        }
    }
}

