/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.driver.internal.BaseDriver;
import org.neo4j.driver.internal.ClusteredErrorHandler;
import org.neo4j.driver.internal.ClusteredNetworkSession;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ConcurrentRoundRobinSet;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.util.BiFunction;
import org.neo4j.driver.v1.util.Function;

public class ClusterDriver
extends BaseDriver {
    private static final String GET_SERVERS = "dbms.cluster.routing.getServers";
    private static final long MAX_TTL = 9223372036854775L;
    private static final Comparator<BoltServerAddress> COMPARATOR = new Comparator<BoltServerAddress>(){

        @Override
        public int compare(BoltServerAddress o1, BoltServerAddress o2) {
            int compare = o1.host().compareTo(o2.host());
            if (compare == 0) {
                compare = Integer.compare(o1.port(), o2.port());
            }
            return compare;
        }
    };
    private static final int MIN_SERVERS = 1;
    private final ConnectionPool connections;
    private final BiFunction<Connection, Logger, Session> sessionProvider;
    private final Clock clock;
    private final ConcurrentRoundRobinSet<BoltServerAddress> routingServers = new ConcurrentRoundRobinSet<BoltServerAddress>(COMPARATOR);
    private final ConcurrentRoundRobinSet<BoltServerAddress> readServers = new ConcurrentRoundRobinSet<BoltServerAddress>(COMPARATOR);
    private final ConcurrentRoundRobinSet<BoltServerAddress> writeServers = new ConcurrentRoundRobinSet<BoltServerAddress>(COMPARATOR);
    private final AtomicLong expires = new AtomicLong(0L);

    public ClusterDriver(BoltServerAddress seedAddress, ConnectionPool connections, SecurityPlan securityPlan, BiFunction<Connection, Logger, Session> sessionProvider, Clock clock, Logging logging) {
        super(securityPlan, logging);
        this.routingServers.add(seedAddress);
        this.connections = connections;
        this.sessionProvider = sessionProvider;
        this.clock = clock;
        this.checkServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkServers() {
        ConcurrentRoundRobinSet<BoltServerAddress> concurrentRoundRobinSet = this.routingServers;
        synchronized (concurrentRoundRobinSet) {
            if (this.expires.get() < this.clock.millis() || this.routingServers.size() < 1 || this.readServers.isEmpty() || this.writeServers.isEmpty()) {
                this.getServers();
            }
        }
    }

    private Set<BoltServerAddress> forgetAllServers() {
        HashSet<BoltServerAddress> seen = new HashSet<BoltServerAddress>();
        seen.addAll(this.routingServers);
        seen.addAll(this.readServers);
        seen.addAll(this.writeServers);
        this.routingServers.clear();
        this.readServers.clear();
        this.writeServers.clear();
        return seen;
    }

    private long calculateNewExpiry(Record record) {
        long ttl = record.get("ttl").asLong();
        long nextExpiry = this.clock.millis() + 1000L * ttl;
        if (ttl < 0L || ttl >= 9223372036854775L || nextExpiry < 0L) {
            return Long.MAX_VALUE;
        }
        return nextExpiry;
    }

    private void getServers() {
        BoltServerAddress address = null;
        try {
            boolean success = false;
            ConcurrentRoundRobinSet<BoltServerAddress> routers = new ConcurrentRoundRobinSet<BoltServerAddress>(this.routingServers);
            final Set<BoltServerAddress> seen = this.forgetAllServers();
            while (!routers.isEmpty() && !success) {
                address = routers.hop();
                success = this.call(address, GET_SERVERS, new Consumer<Record>(){

                    @Override
                    public void accept(Record record) {
                        ClusterDriver.this.expires.set(ClusterDriver.this.calculateNewExpiry(record));
                        List servers = ClusterDriver.this.servers(record);
                        for (ServerInfo server : servers) {
                            seen.removeAll(server.addresses());
                            switch (server.role()) {
                                case "READ": {
                                    ClusterDriver.this.readServers.addAll(server.addresses());
                                    break;
                                }
                                case "WRITE": {
                                    ClusterDriver.this.writeServers.addAll(server.addresses());
                                    break;
                                }
                                case "ROUTE": {
                                    ClusterDriver.this.routingServers.addAll(server.addresses());
                                }
                            }
                        }
                    }
                });
            }
            if (!success) {
                throw new ServiceUnavailableException("Run out of servers");
            }
            for (BoltServerAddress remove : seen) {
                this.connections.purge(remove);
            }
        }
        catch (Exception ex) {
            this.close();
            throw new ServiceUnavailableException(String.format("Server %s couldn't perform discovery", address == null ? "`UNKNOWN`" : address.toString()), ex);
        }
    }

    private List<ServerInfo> servers(Record record) {
        return record.get("servers").asList(new Function<Value, ServerInfo>(){

            @Override
            public ServerInfo apply(Value value) {
                return new ServerInfo(value.get("addresses").asList(new Function<Value, BoltServerAddress>(){

                    @Override
                    public BoltServerAddress apply(Value value) {
                        return new BoltServerAddress(value.asString());
                    }
                }), value.get("role").asString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean call(BoltServerAddress address, String procedureName, Consumer<Record> recorder) {
        Connection acquire = null;
        Session session = null;
        try {
            acquire = this.connections.acquire(address);
            session = this.sessionProvider.apply(acquire, this.log);
            StatementResult records = session.run(String.format("CALL %s", procedureName));
            while (records.hasNext()) {
                recorder.accept(records.next());
            }
        }
        catch (ConnectionFailureException e) {
            this.forget(address);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (acquire != null) {
                acquire.close();
            }
        }
        return true;
    }

    private synchronized void forget(BoltServerAddress address) {
        this.connections.purge(address);
        this.routingServers.remove(address);
        this.readServers.remove(address);
        this.writeServers.remove(address);
    }

    @Override
    public Session session() {
        return this.session(AccessMode.WRITE);
    }

    @Override
    public Session session(AccessMode mode) {
        return new ClusteredNetworkSession(mode, this.acquireConnection(mode), new ClusteredErrorHandler(){

            @Override
            public void onConnectionFailure(BoltServerAddress address) {
                ClusterDriver.this.forget(address);
            }

            @Override
            public void onWriteFailure(BoltServerAddress address) {
                ClusterDriver.this.writeServers.remove(address);
            }
        }, this.log);
    }

    private Connection acquireConnection(AccessMode role) {
        this.checkServers();
        switch (role) {
            case READ: {
                return this.connections.acquire(this.readServers.hop());
            }
            case WRITE: {
                return this.connections.acquire(this.writeServers.hop());
            }
        }
        throw new ClientException((Object)((Object)role) + " is not supported for creating new sessions");
    }

    @Override
    public void close() {
        try {
            this.connections.close();
        }
        catch (Exception ex) {
            this.log.error(String.format("~~ [ERROR] %s", ex.getMessage()), ex);
        }
    }

    Set<BoltServerAddress> routingServers() {
        return Collections.unmodifiableSet(this.routingServers);
    }

    Set<BoltServerAddress> readServers() {
        return Collections.unmodifiableSet(this.readServers);
    }

    Set<BoltServerAddress> writeServers() {
        return Collections.unmodifiableSet(this.writeServers);
    }

    ConnectionPool connectionPool() {
        return this.connections;
    }

    private static class ServerInfo {
        private final List<BoltServerAddress> addresses;
        private final String role;

        public ServerInfo(List<BoltServerAddress> addresses, String role) {
            this.addresses = addresses;
            this.role = role;
        }

        public String role() {
            return this.role;
        }

        List<BoltServerAddress> addresses() {
            return this.addresses;
        }
    }
}

