/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.neo4j.driver.internal.util.BytePrinter;
import org.neo4j.driver.v1.exceptions.ClientException;

public final class SocketUtils {
    private SocketUtils() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static void blockingRead(ByteChannel channel, ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            if (channel.read(buf) >= 0) continue;
            String bufStr = BytePrinter.hex(buf).trim();
            throw new ClientException(String.format("Connection terminated while receiving data. This can happen due to network instabilities, or due to restarts of the database. Expected %s bytes, received %s.", buf.limit(), bufStr.isEmpty() ? "none" : bufStr));
        }
    }

    public static void blockingWrite(ByteChannel channel, ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            if (channel.write(buf) >= 0) continue;
            String bufStr = BytePrinter.hex(buf).trim();
            throw new ClientException(String.format("Connection terminated while sending data. This can happen due to network instabilities, or due to restarts of the database. Expected %s bytes, wrote %s.", buf.limit(), bufStr.isEmpty() ? "none" : bufStr));
        }
    }
}

