/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.util.Arrays;
import java.util.Map;
import org.neo4j.driver.internal.connector.socket.SocketResponseHandler;
import org.neo4j.driver.internal.messaging.AckFailureMessage;
import org.neo4j.driver.internal.messaging.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.IgnoredMessage;
import org.neo4j.driver.internal.messaging.PullAllMessage;
import org.neo4j.driver.internal.messaging.ResetMessage;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Value;

public class LoggingResponseHandler
extends SocketResponseHandler {
    private static final String DEFAULT_DEBUG_LOGGING_FORMAT = "S: %s";
    private final Logger logger;

    public LoggingResponseHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void handleInitMessage(String clientNameAndVersion, Map<String, Value> authToken) {
        this.logger.debug("S: [INIT \"%s\"]", clientNameAndVersion);
        super.handleInitMessage(clientNameAndVersion, authToken);
    }

    @Override
    public void handleRunMessage(String statement, Map<String, Value> parameters) {
        this.logger.debug("S: [RUN \"%s\" %s]", statement, parameters);
        super.handleRunMessage(statement, parameters);
    }

    @Override
    public void handlePullAllMessage() {
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, PullAllMessage.PULL_ALL);
        super.handlePullAllMessage();
    }

    @Override
    public void handleDiscardAllMessage() {
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, DiscardAllMessage.DISCARD_ALL);
        super.handleDiscardAllMessage();
    }

    @Override
    public void handleResetMessage() {
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, ResetMessage.RESET);
        super.handleResetMessage();
    }

    @Override
    public void handleAckFailureMessage() {
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, AckFailureMessage.ACK_FAILURE);
        super.handleAckFailureMessage();
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        this.logger.debug("S: [SUCCESS %s]", meta);
        super.handleSuccessMessage(meta);
    }

    @Override
    public void handleRecordMessage(Value[] fields) {
        this.logger.debug("S: [RECORD %s]", Arrays.asList(fields));
        super.handleRecordMessage(fields);
    }

    @Override
    public void handleFailureMessage(String code, String message) {
        this.logger.debug("S: [FAILURE %s \"%s\"]", code, message);
        super.handleFailureMessage(code, message);
    }

    @Override
    public void handleIgnoredMessage() {
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, IgnoredMessage.IGNORED);
        super.handleIgnoredMessage();
    }
}

