/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import org.neo4j.driver.internal.util.BytePrinter;
import org.neo4j.driver.v1.exceptions.ClientException;

public class AllOrNothingChannel
implements ByteChannel {
    private final SocketChannel channel;

    public AllOrNothingChannel(SocketChannel channel) throws IOException {
        this.channel = channel;
        this.channel.configureBlocking(true);
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        int toRead = buf.remaining();
        while (buf.remaining() > 0) {
            int read = this.channel.read(buf);
            if (read != -1) continue;
            throw new ClientException(String.format("Connection terminated while receiving data. This can happen due to network instabilities, or due to restarts of the database. Expected %s bytes, received %s.", buf.limit(), BytePrinter.hex(buf)));
        }
        return toRead;
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        int toWrite = buf.remaining();
        while (buf.remaining() > 0) {
            int write = this.channel.write(buf);
            if (write != -1) continue;
            throw new ClientException(String.format("Connection terminated while sending data. This can happen due to network instabilities, or due to restarts of the database. Expected %s bytes, wrote %s.", buf.limit(), BytePrinter.hex(buf)));
        }
        return toWrite;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

