/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.io.IOException;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageHandler;

public class FailureMessage
implements Message {
    private final String code;
    private final String message;

    public FailureMessage(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public void dispatch(MessageHandler handler) throws IOException {
        handler.handleFailureMessage(this.code, this.message);
    }

    public String toString() {
        return String.format("[FAILURE %s \"%s\"]", this.code, this.message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailureMessage that = (FailureMessage)o;
        return !(this.code == null ? that.code != null : !this.code.equals(that.code)) && !(this.message == null ? that.message != null : !this.message.equals(that.message));
    }

    public int hashCode() {
        int result = this.code != null ? this.code.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }
}

