/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.summary.SummaryBuilder;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.summary.StatementType;
import org.neo4j.driver.v1.summary.SummaryCounters;
import org.neo4j.driver.v1.util.Function;
import org.neo4j.driver.v1.util.Functions;

public class InternalStatementResult
implements StatementResult {
    private final Connection connection;
    private final StreamCollector runResponseCollector;
    private final StreamCollector pullAllResponseCollector;
    private final Queue<Record> recordBuffer = new LinkedList<Record>();
    private List<String> keys = null;
    private ResultSummary summary = null;
    private boolean open = true;
    private long position = -1L;
    private boolean done = false;

    public InternalStatementResult(Connection connection, Statement statement) {
        this.connection = connection;
        this.runResponseCollector = this.newRunResponseCollector();
        this.pullAllResponseCollector = this.newPullAllResponseCollector(statement);
    }

    private StreamCollector newRunResponseCollector() {
        return new StreamCollector(){

            @Override
            public void keys(String[] names) {
                InternalStatementResult.this.keys = Arrays.asList(names);
            }

            @Override
            public void record(Value[] fields) {
            }

            @Override
            public void statementType(StatementType type) {
            }

            @Override
            public void statementStatistics(SummaryCounters statistics) {
            }

            @Override
            public void plan(Plan plan) {
            }

            @Override
            public void profile(ProfiledPlan plan) {
            }

            @Override
            public void notifications(List<Notification> notifications) {
            }

            @Override
            public void done() {
                if (InternalStatementResult.this.keys == null) {
                    InternalStatementResult.this.keys = new ArrayList();
                }
            }
        };
    }

    private StreamCollector newPullAllResponseCollector(Statement statement) {
        final SummaryBuilder summaryBuilder = new SummaryBuilder(statement);
        return new StreamCollector(){

            @Override
            public void keys(String[] names) {
            }

            @Override
            public void record(Value[] fields) {
                InternalStatementResult.this.recordBuffer.add(new InternalRecord(InternalStatementResult.this.keys, fields));
            }

            @Override
            public void statementType(StatementType type) {
                summaryBuilder.statementType(type);
            }

            @Override
            public void statementStatistics(SummaryCounters statistics) {
                summaryBuilder.statementStatistics(statistics);
            }

            @Override
            public void plan(Plan plan) {
                summaryBuilder.plan(plan);
            }

            @Override
            public void profile(ProfiledPlan plan) {
                summaryBuilder.profile(plan);
            }

            @Override
            public void notifications(List<Notification> notifications) {
                summaryBuilder.notifications(notifications);
            }

            @Override
            public void done() {
                InternalStatementResult.this.summary = summaryBuilder.build();
                InternalStatementResult.this.done = true;
            }
        };
    }

    StreamCollector runResponseCollector() {
        return this.runResponseCollector;
    }

    StreamCollector pullAllResponseCollector() {
        return this.pullAllResponseCollector;
    }

    @Override
    public List<String> keys() {
        this.tryFetching();
        return this.keys;
    }

    @Override
    public boolean hasNext() {
        if (!this.recordBuffer.isEmpty()) {
            return true;
        }
        if (this.done) {
            return false;
        }
        this.tryFetching();
        return this.hasNext();
    }

    @Override
    public Record next() {
        this.assertOpen();
        Record nextRecord = this.recordBuffer.poll();
        if (nextRecord != null) {
            ++this.position;
            return nextRecord;
        }
        if (this.done) {
            return null;
        }
        this.tryFetching();
        return this.next();
    }

    @Override
    public Record single() {
        if (this.position > 0L) {
            throw new NoSuchRecordException("Cannot retrieve the first record, because other operations have already used the first record. Please ensure you are not calling `first` multiple times, or are mixing it with calls to `next`, `single`, `list` or any other method that changes the position of the cursor.");
        }
        if (!this.hasNext()) {
            throw new NoSuchRecordException("Cannot retrieve the first record, because this result is empty.");
        }
        Record first = this.next();
        if (this.hasNext()) {
            throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record, or use `first` instead of `single` if you do not care about the number of records in the result.");
        }
        return first;
    }

    @Override
    public Record peek() {
        this.assertOpen();
        Record nextRecord = this.recordBuffer.peek();
        if (nextRecord != null) {
            return nextRecord;
        }
        if (this.done) {
            return null;
        }
        this.tryFetching();
        return this.peek();
    }

    @Override
    public List<Record> list() {
        return this.list(Functions.identity());
    }

    @Override
    public <T> List<T> list(Function<Record, T> mapFunction) {
        if (this.isEmpty()) {
            this.assertOpen();
            return Collections.emptyList();
        }
        if (this.position == -1L && this.hasNext()) {
            ArrayList<T> result = new ArrayList<T>();
            do {
                result.add(mapFunction.apply(this.next()));
            } while (this.hasNext());
            this.consume();
            return result;
        }
        throw new ClientException(String.format("Can't retain records when cursor is not pointing at the first record (currently at position %d)", this.position));
    }

    @Override
    public ResultSummary consume() {
        if (!this.open) {
            return this.summary;
        }
        while (!this.done) {
            this.connection.receiveOne();
        }
        this.recordBuffer.clear();
        this.open = false;
        return this.summary;
    }

    @Override
    public void remove() {
        throw new ClientException("Removing records from a result is not supported.");
    }

    private void assertOpen() {
        if (!this.open) {
            throw new ClientException("Result has been closed");
        }
    }

    private boolean isEmpty() {
        this.tryFetching();
        return this.position == -1L && this.recordBuffer.isEmpty() && this.done;
    }

    private void tryFetching() {
        while (this.recordBuffer.isEmpty() && !this.done) {
            this.connection.receiveOne();
        }
    }
}

