/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.URI;
import org.neo4j.driver.internal.InternalSession;
import org.neo4j.driver.internal.pool.InternalConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;

public class InternalDriver
implements Driver {
    private final ConnectionPool connections;
    private final URI url;
    private final Config config;

    public InternalDriver(URI url, AuthToken authToken, Config config) {
        this.url = url;
        this.connections = new InternalConnectionPool(config, authToken);
        this.config = config;
    }

    @Override
    public Session session() {
        return new InternalSession(this.connections.acquire(this.url), this.config.logging().getLog("session"));
    }

    @Override
    public void close() throws Exception {
        this.connections.close();
    }
}

