/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.RecordAccessor;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public abstract class Records {
    private static final Function<RecordAccessor, Record> RECORD = new Function<RecordAccessor, Record>(){

        @Override
        public Record apply(RecordAccessor recordAccessor) {
            return recordAccessor.record();
        }
    };

    public static Function<RecordAccessor, Record> recordAsIs() {
        return RECORD;
    }

    public static Function<RecordAccessor, Value> columnAsIs(int index) {
        return Records.column(index, Values.valueAsIs());
    }

    public static Function<RecordAccessor, Value> columnAsIs(String key) {
        return Records.column(key, Values.valueAsIs());
    }

    public static <T> Function<RecordAccessor, T> column(final int index, final Function<Value, T> mapFunction) {
        return new Function<RecordAccessor, T>(){

            @Override
            public T apply(RecordAccessor recordAccessor) {
                return mapFunction.apply(recordAccessor.get(index));
            }
        };
    }

    public static <T> Function<RecordAccessor, T> column(final String key, final Function<Value, T> mapFunction) {
        return new Function<RecordAccessor, T>(){

            @Override
            public T apply(RecordAccessor recordAccessor) {
                return mapFunction.apply(recordAccessor.get(key));
            }
        };
    }
}

