/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.InternalResultCursor;
import org.neo4j.driver.internal.ParameterSupport;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.summary.SummaryBuilder;
import org.neo4j.driver.v1.Notification;
import org.neo4j.driver.v1.Plan;
import org.neo4j.driver.v1.ProfiledPlan;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.ResultCursor;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementType;
import org.neo4j.driver.v1.UpdateStatistics;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class ResultBuilder
implements StreamCollector {
    private static final List<String> NO_KEYS = new ArrayList<String>();
    private final SummaryBuilder summaryBuilder;
    private List<Record> body = new ArrayList<Record>();
    private List<String> keys = NO_KEYS;
    private Map<String, Integer> keyIndexLookup = null;

    public ResultBuilder(String statement, Map<String, Value> parameters) {
        Map<String, Value> unmodifiableParameters = parameters == null || parameters.isEmpty() ? ParameterSupport.NO_PARAMETERS : Collections.unmodifiableMap(parameters);
        this.summaryBuilder = new SummaryBuilder(new Statement(statement, unmodifiableParameters));
    }

    @Override
    public void keys(String[] names) {
        if (this.keys == NO_KEYS) {
            int numFields = names.length;
            if (numFields == 0) {
                this.keys = Collections.emptyList();
                this.keyIndexLookup = Collections.emptyMap();
            } else {
                HashMap<String, Integer> fieldLookup = new HashMap<String, Integer>(numFields);
                ArrayList<String> fields = new ArrayList<String>(numFields);
                for (int i = 0; i < numFields; ++i) {
                    String name = names[i];
                    fields.add(name);
                    fieldLookup.put(name, i);
                }
                this.keys = fields;
                this.keyIndexLookup = fieldLookup;
            }
        } else {
            throw new ClientException("Received field names twice");
        }
    }

    @Override
    public void record(Value[] values) {
        this.body.add(new InternalRecord(this.keys, this.keyIndexLookup, values));
    }

    @Override
    public void statementType(StatementType type) {
        this.summaryBuilder.statementType(type);
    }

    @Override
    public void statementStatistics(UpdateStatistics statistics) {
        this.summaryBuilder.statementStatistics(statistics);
    }

    @Override
    public void plan(Plan plan) {
        this.summaryBuilder.plan(plan);
    }

    @Override
    public void profile(ProfiledPlan plan) {
        this.summaryBuilder.profile(plan);
    }

    @Override
    public void notifications(List<Notification> notifications) {
        this.summaryBuilder.notifications(notifications);
    }

    public ResultCursor build() {
        return new InternalResultCursor(this.keys, this.body, this.summaryBuilder.build());
    }
}

