/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.ParameterSupport;
import org.neo4j.driver.v1.Immutable;
import org.neo4j.driver.v1.Value;

@Immutable
public class Statement {
    private final String template;
    private final Map<String, Value> parameters;

    public Statement(String template, Map<String, Value> parameters) {
        this.template = template;
        this.parameters = parameters == null || parameters.isEmpty() ? ParameterSupport.NO_PARAMETERS : Collections.unmodifiableMap(parameters);
    }

    public Statement(String template) {
        this(template, null);
    }

    public String template() {
        return this.template;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    public Statement withTemplate(String newTemplate) {
        return new Statement(newTemplate, this.parameters);
    }

    public Statement withParameters(Map<String, Value> newParameters) {
        return new Statement(this.template, newParameters);
    }

    public Statement withUpdatedParameters(Map<String, Value> updates) {
        if (updates == null || updates.isEmpty()) {
            return this;
        }
        HashMap<String, Value> newParameters = new HashMap<String, Value>(Math.max(this.parameters.size(), updates.size()));
        newParameters.putAll(this.parameters);
        for (Map.Entry<String, Value> entry : updates.entrySet()) {
            Value value = entry.getValue();
            if (value.isNull()) {
                newParameters.remove(entry.getKey());
                continue;
            }
            newParameters.put(entry.getKey(), value);
        }
        return this.withParameters(newParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement statement = (Statement)o;
        return this.template.equals(statement.template) && this.parameters.equals(statement.parameters);
    }

    public int hashCode() {
        int result = this.template.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Statement{template='%s', parameters=%s}", this.template, this.parameters);
    }
}

