/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.v1.Function;

public class Iterables {
    public static int count(Iterable<?> it) {
        if (it instanceof Collection) {
            return ((Collection)it).size();
        }
        int size = 0;
        for (Object o : it) {
            ++size;
        }
        return size;
    }

    public static <T> List<T> asList(Iterable<T> it) {
        if (it instanceof List) {
            return (List)it;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T t : it) {
            list.add(t);
        }
        return list;
    }

    public static <A, B> Iterable<B> map(final Iterable<A> it, final Function<A, B> f) {
        return new Iterable<B>(){

            @Override
            public Iterator<B> iterator() {
                final Iterator aIterator = it.iterator();
                return new Iterator<B>(){

                    @Override
                    public boolean hasNext() {
                        return aIterator.hasNext();
                    }

                    @Override
                    public B next() {
                        return f.apply(aIterator.next());
                    }

                    @Override
                    public void remove() {
                        aIterator.remove();
                    }
                };
            }
        };
    }

    public static <K, A, B> Map<K, B> mapValues(Map<K, A> map, Function<A, B> f) {
        HashMap<K, B> transformed = new HashMap<K, B>(map.size());
        for (Map.Entry<K, A> entry : map.entrySet()) {
            transformed.put(entry.getKey(), f.apply(entry.getValue()));
        }
        return transformed;
    }
}

