/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Iterator;
import org.neo4j.driver.internal.InternalPair;
import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.Pair;

public abstract class Format {
    private Format() {
        throw new UnsupportedOperationException();
    }

    public static <V> String formatPairs(Function<V, String> printValue, int propertyCount, Iterable<Pair<String, V>> Entries) {
        switch (propertyCount) {
            case 0: {
                return "{}";
            }
            case 1: {
                return String.format("{%s}", Format.internalPair(Entries.iterator().next()).toString(printValue));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        Iterator<Pair<String, V>> iterator = Entries.iterator();
        builder.append(Format.internalPair(iterator.next()).toString(printValue));
        while (iterator.hasNext()) {
            builder.append(',');
            builder.append(' ');
            builder.append(Format.internalPair(iterator.next()).toString(printValue));
        }
        builder.append("}");
        return builder.toString();
    }

    private static <V> InternalPair<String, V> internalPair(Pair<String, V> property) {
        return (InternalPair)property;
    }

    public static <V> String formatElements(Function<V, String> printValue, V[] elements) {
        int elementCount = elements.length;
        switch (elementCount) {
            case 0: {
                return "[]";
            }
            case 1: {
                return String.format("[%s]", printValue.apply(elements[0]));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(printValue.apply(elements[0]));
        for (int i = 1; i < elementCount; ++i) {
            builder.append(',');
            builder.append(' ');
            builder.append(printValue.apply(elements[i]));
        }
        builder.append("]");
        return builder.toString();
    }
}

