/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.pool;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.connector.socket.SocketConnector;
import org.neo4j.driver.internal.pool.Allocator;
import org.neo4j.driver.internal.pool.PooledConnection;
import org.neo4j.driver.internal.pool.PooledConnectionValidator;
import org.neo4j.driver.internal.pool.ThreadCachingPool;
import org.neo4j.driver.internal.pool.ValidationStrategy;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.Connector;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.exceptions.ClientException;

public class InternalConnectionPool
implements ConnectionPool {
    private final ConcurrentHashMap<String, Connector> connectors = new ConcurrentHashMap();
    private final ConcurrentHashMap<URI, ThreadCachingPool<PooledConnection>> pools = new ConcurrentHashMap();
    private final ValidationStrategy<PooledConnection> connectionValidation;
    private final Clock clock;
    private final Config config;

    public InternalConnectionPool(Config config) {
        this(InternalConnectionPool.loadConnectors(), Clock.SYSTEM, config);
    }

    public InternalConnectionPool(Collection<Connector> conns, Clock clock, Config config) {
        this.config = config;
        this.clock = clock;
        this.connectionValidation = new PooledConnectionValidator(config.idleTimeBeforeConnectionTest());
        for (Connector connector : conns) {
            for (String s : connector.supportedSchemes()) {
                this.connectors.put(s, connector);
            }
        }
    }

    @Override
    public Connection acquire(URI sessionURI) {
        try {
            PooledConnection conn = this.pool(sessionURI).acquire(30L, TimeUnit.SECONDS);
            if (conn == null) {
                throw new ClientException("Failed to acquire a session with Neo4j as all the connections in the connection pool are already occupied by other sessions. Please close unused session and retry. Current Pool size: " + this.config.connectionPoolSize() + ". If your application requires running more sessions concurrently than the current pool " + "size, you should create a driver with a larger connection pool size.");
            }
            return conn;
        }
        catch (InterruptedException e) {
            throw new ClientException("Interrupted while waiting for a connection to Neo4j.");
        }
    }

    private ThreadCachingPool<PooledConnection> pool(URI sessionURI) {
        ThreadCachingPool<PooledConnection> pool = this.pools.get(sessionURI);
        if (pool == null && this.pools.putIfAbsent(sessionURI, pool = this.newPool(sessionURI)) != null) {
            pool.close();
            return this.pool(sessionURI);
        }
        return pool;
    }

    private static Collection<Connector> loadConnectors() {
        LinkedList<Connector> connectors = new LinkedList<Connector>();
        SocketConnector conn = new SocketConnector();
        connectors.add(conn);
        ServiceLoader<Connector> load = ServiceLoader.load(Connector.class);
        for (Connector connector : load) {
            connectors.add(connector);
        }
        return connectors;
    }

    @Override
    public void close() throws Exception {
        for (ThreadCachingPool<PooledConnection> pool : this.pools.values()) {
            pool.close();
        }
        this.pools.clear();
    }

    private String connectorSchemes() {
        return Arrays.toString(this.connectors.keySet().toArray(new String[this.connectors.keySet().size()]));
    }

    private ThreadCachingPool<PooledConnection> newPool(final URI uri) {
        return new ThreadCachingPool<PooledConnection>(this.config.connectionPoolSize(), new Allocator<PooledConnection>(){

            @Override
            public PooledConnection allocate(Consumer<PooledConnection> release) {
                Connector connector = (Connector)InternalConnectionPool.this.connectors.get(uri.getScheme());
                if (connector == null) {
                    throw new ClientException("'" + uri.getScheme() + "' is not a supported transport (in '" + uri + "', available transports are: " + InternalConnectionPool.this.connectorSchemes() + ".");
                }
                Connection conn = connector.connect(uri, InternalConnectionPool.this.config);
                return new PooledConnection(conn, release);
            }

            @Override
            public void onDispose(PooledConnection pooledConnection) {
                pooledConnection.dispose();
            }

            @Override
            public void onAcquire(PooledConnection pooledConnection) {
            }
        }, this.connectionValidation, this.clock);
    }
}

