/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.pool;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.pool.PooledConnection;
import org.neo4j.driver.internal.pool.ValidationStrategy;
import org.neo4j.driver.internal.spi.StreamCollector;

public class PooledConnectionValidator
implements ValidationStrategy<PooledConnection> {
    private static final Map<String, Value> NO_PARAMETERS = new HashMap<String, Value>();
    private final long minIdleBeforeConnectionTest;

    public PooledConnectionValidator(long minIdleBeforeConnectionTest) {
        this.minIdleBeforeConnectionTest = minIdleBeforeConnectionTest;
    }

    @Override
    public boolean isValid(PooledConnection conn, long idleTime) {
        if (conn.hasUnrecoverableErrors()) {
            return false;
        }
        return idleTime <= this.minIdleBeforeConnectionTest || this.ping(conn);
    }

    private boolean ping(PooledConnection conn) {
        try {
            conn.run("RETURN 1 // JavaDriver poll to test connection", NO_PARAMETERS, StreamCollector.NO_OP);
            conn.pullAll(StreamCollector.NO_OP);
            conn.sync();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

