/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.StatementType;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DatabaseException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.messaging.MessageHandler;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.summary.SimpleNotification;
import org.neo4j.driver.internal.summary.SimplePlan;
import org.neo4j.driver.internal.summary.SimpleProfiledPlan;
import org.neo4j.driver.internal.summary.SimpleUpdateStatistics;

public class SocketResponseHandler
implements MessageHandler {
    private final Map<Integer, StreamCollector> collectors = new HashMap<Integer, StreamCollector>();
    private Neo4jException error;
    private int responseId = 0;

    public int receivedResponses() {
        return this.responseId;
    }

    @Override
    public void handleRecordMessage(Value[] fields) {
        StreamCollector collector = this.collectors.get(this.responseId);
        if (collector != null) {
            collector.record(fields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleFailureMessage(String code, String message) {
        try {
            String classification;
            String[] parts = code.split("\\.");
            switch (classification = parts[1]) {
                case "ClientError": {
                    this.error = new ClientException(code, message);
                    return;
                }
                case "TransientError": {
                    this.error = new TransientException(code, message);
                    return;
                }
                default: {
                    this.error = new DatabaseException(code, message);
                    return;
                }
            }
        }
        finally {
            ++this.responseId;
        }
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        StreamCollector collector = this.collectors.get(this.responseId);
        if (collector != null) {
            this.collectFields(collector, meta.get("fields"));
            this.collectType(collector, meta.get("type"));
            this.collectStatistics(collector, meta.get("stats"));
            this.collectPlan(collector, meta.get("plan"));
            this.collectProfile(collector, meta.get("profile"));
            this.collectNotifications(collector, meta.get("notifications"));
        }
        ++this.responseId;
    }

    private void collectNotifications(StreamCollector collector, Value notifications) {
        if (notifications != null) {
            collector.notifications(notifications.javaList(SimpleNotification.VALUE_TO_NOTIFICATION));
        }
    }

    private void collectPlan(StreamCollector collector, Value plan) {
        if (plan != null) {
            collector.plan(SimplePlan.EXPLAIN_PLAN_FROM_VALUE.apply(plan));
        }
    }

    private void collectProfile(StreamCollector collector, Value plan) {
        if (plan != null) {
            collector.profile(SimpleProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(plan));
        }
    }

    private void collectFields(StreamCollector collector, Value fieldValue) {
        if (fieldValue != null && fieldValue.size() > 0L) {
            String[] fields = new String[(int)fieldValue.size()];
            int idx = 0;
            for (Value value : fieldValue) {
                fields[idx++] = value.javaString();
            }
            collector.fieldNames(fields);
        }
    }

    private void collectType(StreamCollector collector, Value type) {
        if (type != null) {
            collector.statementType(StatementType.fromCode(type.javaString()));
        }
    }

    private void collectStatistics(StreamCollector collector, Value stats) {
        if (stats != null) {
            collector.statementStatistics(new SimpleUpdateStatistics(this.statsValue(stats, "nodes-created"), this.statsValue(stats, "nodes-deleted"), this.statsValue(stats, "relationships-created"), this.statsValue(stats, "relationships-deleted"), this.statsValue(stats, "properties-set"), this.statsValue(stats, "labels-added"), this.statsValue(stats, "labels-removed"), this.statsValue(stats, "indexes-added"), this.statsValue(stats, "indexes-removed"), this.statsValue(stats, "constraints-added"), this.statsValue(stats, "constraints-removed")));
        }
    }

    private int statsValue(Value stats, String name) {
        Value value = stats.get(name);
        return value == null ? 0 : value.javaInteger();
    }

    @Override
    public void handleIgnoredMessage() {
        ++this.responseId;
    }

    @Override
    public void handleDiscardAllMessage() {
    }

    @Override
    public void handleAckFailureMessage() {
    }

    @Override
    public void handlePullAllMessage() {
    }

    @Override
    public void handleInitMessage(String clientNameAndVersion) {
    }

    @Override
    public void handleRunMessage(String statement, Map<String, Value> parameters) {
    }

    public void registerResultCollector(int correlationId, StreamCollector collector) {
        this.collectors.put(correlationId, collector);
    }

    public boolean serverFailureOccurred() {
        return this.error != null;
    }

    public Neo4jException serverFailure() {
        return this.error;
    }

    public void clear() {
        this.responseId = 0;
        this.error = null;
        this.collectors.clear();
    }
}

