/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;

public class SimpleRecord
implements Record {
    private final Map<String, Integer> fieldLookup;
    private final Value[] fields;

    public static Record record(Object ... alternatingFieldNameValue) {
        HashMap<String, Integer> lookup = new HashMap<String, Integer>();
        Value[] fields = new Value[alternatingFieldNameValue.length / 2];
        for (int i = 0; i < alternatingFieldNameValue.length; i += 2) {
            lookup.put(alternatingFieldNameValue[i].toString(), i / 2);
            fields[i / 2] = (Value)alternatingFieldNameValue[i + 1];
        }
        return new SimpleRecord(lookup, fields);
    }

    public SimpleRecord(Map<String, Integer> fieldLookup, Value[] fields) {
        this.fieldLookup = fieldLookup;
        this.fields = fields;
    }

    @Override
    public Value get(int fieldIndex) {
        return this.fields[fieldIndex];
    }

    @Override
    public Value get(String fieldName) {
        Integer fieldIndex = this.fieldLookup.get(fieldName);
        if (fieldIndex == null) {
            return null;
        }
        return this.fields[fieldIndex];
    }

    @Override
    public Iterable<String> fieldNames() {
        return this.fieldLookup.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRecord that = (SimpleRecord)o;
        if (!this.fieldLookup.equals(that.fieldLookup)) {
            return false;
        }
        return Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        int result = this.fieldLookup.hashCode();
        result = 31 * result + Arrays.hashCode(this.fields);
        return result;
    }
}

