/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.ParameterSupport;

public class Statement {
    private final String text;
    private final Map<String, Value> parameters;

    public Statement(String text, Map<String, Value> parameters) {
        this.text = text;
        this.parameters = parameters == null || parameters.isEmpty() ? ParameterSupport.NO_PARAMETERS : Collections.unmodifiableMap(parameters);
    }

    public Statement(String text) {
        this(text, null);
    }

    public String text() {
        return this.text;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    public Statement withText(String newText) {
        return new Statement(newText, this.parameters);
    }

    public Statement withParameters(Map<String, Value> newParameters) {
        return new Statement(this.text, newParameters);
    }

    public Statement withUpdatedParameters(Map<String, Value> updates) {
        if (updates == null || updates.isEmpty()) {
            return this;
        }
        HashMap<String, Value> newParameters = new HashMap<String, Value>(Math.max(this.parameters.size(), updates.size()));
        newParameters.putAll(this.parameters);
        for (Map.Entry<String, Value> entry : updates.entrySet()) {
            Value value = entry.getValue();
            if (value == null) {
                newParameters.remove(entry.getKey());
                continue;
            }
            newParameters.put(entry.getKey(), value);
        }
        return this.withParameters(newParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement statement = (Statement)o;
        return this.text.equals(statement.text) && this.parameters.equals(statement.parameters);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Statement{text='%s', parameters=%s}", this.text, this.parameters);
    }
}

