/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.printer.AnsiFormattedText;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record Param(ParameterService parameters) implements Command
{
    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 1);
        try {
            ParameterService.RawParameter parsed = this.parameters.parse(args.get(0));
            this.parameters.setParameter(this.parameters.evaluate(parsed));
        }
        catch (ParameterService.ParameterParsingException e) {
            throw new CommandException(AnsiFormattedText.from("Incorrect usage.\nusage: ").bold(this.metadata().name()).append(" ").append(this.metadata().usage()));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "Set the specified query parameter to the value given";
            String usage = "name => <Cypher Expression>\n\nFor example:\n    :param name => 42\n    :param name => 'string value'\n    :param name => { mapKey: 'map value' }\n    :param name => [ 1, 2, 3 ]\n";
            return new Command.Metadata(":param", "Set the value of a query parameter", usage, help, List.of());
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new Param(args.parameters());
        }
    }
}

