/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.util.List;
import java.util.stream.Stream;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.parser.CypherLanguageService;
import org.neo4j.shell.terminal.StatementJlineParser;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JlineCompleter
implements Completer {
    private final CommandCompleter commandCompleter;
    private final CypherCompleter cypherCompleter;
    private final boolean enableCypherCompletion;

    public JlineCompleter(CommandHelper.CommandFactoryHelper commands, CypherLanguageService parser, ParameterService parameters, boolean enableCypherCompletion) {
        this.commandCompleter = CommandCompleter.from(commands);
        this.cypherCompleter = new CypherCompleter(parser, parameters);
        this.enableCypherCompletion = enableCypherCompletion;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        try {
            if (line instanceof StatementJlineParser.BlankCompletion) {
                candidates.addAll(this.commandCompleter.complete());
                if (this.enableCypherCompletion) {
                    this.cypherCompleter.completeBlank().forEach(candidates::add);
                }
            } else if (line instanceof StatementJlineParser.CommandCompletion) {
                candidates.addAll(this.commandCompleter.complete());
            } else if (this.enableCypherCompletion && line instanceof StatementJlineParser.CypherCompletion) {
                StatementJlineParser.CypherCompletion cypher = (StatementJlineParser.CypherCompletion)line;
                this.cypherCompleter.complete(cypher).forEach(candidates::add);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record CommandCompleter(List<Suggestion> allCommands) {
        List<Suggestion> complete() {
            return this.allCommands;
        }

        public static CommandCompleter from(CommandHelper.CommandFactoryHelper commands) {
            return new CommandCompleter(commands.metadata().map(Suggestion::command).toList());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record CypherCompleter(CypherLanguageService parser, ParameterService parameterMap) {
        Stream<Suggestion> complete(StatementJlineParser.CypherCompletion cypher) {
            return CypherCompleter.concat(this.identifiers(cypher), this.parameters(), this.keywords(this.queryUntilCompletionWord(cypher)));
        }

        Stream<Suggestion> completeBlank() {
            return CypherCompleter.concat(this.keywords(""), this.parameters());
        }

        private Stream<Suggestion> keywords(String query) {
            List<String> suggested = this.parser.suggestNextKeyword(query);
            if (suggested.isEmpty()) {
                return this.parser.keywords().map(Suggestion::cypher);
            }
            return suggested.stream().map(Suggestion::cypher);
        }

        private Stream<Suggestion> identifiers(StatementJlineParser.CypherCompletion cypher) {
            return cypher.tokens().stream().filter(t -> t.isIdentifier() && !t.isParameterIdentifier()).filter(i -> i.endOffset() + cypher.statement().beginOffset() != cypher.statement().endOffset()).map(t -> Suggestion.identifier(t.image()));
        }

        private Stream<Suggestion> parameters() {
            return this.parameterMap.parameters().keySet().stream().map(Suggestion::parameter);
        }

        private String queryUntilCompletionWord(StatementJlineParser.CypherCompletion cypher) {
            int cutAt = cypher.cursor() - cypher.wordCursor() - cypher.statement().beginOffset();
            return cypher.statement().statement().substring(0, cutAt);
        }

        @SafeVarargs
        private static <T> Stream<T> concat(Stream<T> ... streams) {
            return Stream.of(streams).reduce(Stream::concat).orElseGet(Stream::empty);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Suggestion
    extends Candidate {
        Suggestion(String value, SuggestionGroup group, String desc, boolean complete) {
            super(value, value, group.groupName, desc, null, null, complete);
        }

        public static Suggestion cypher(String cypher) {
            return new Suggestion(cypher, SuggestionGroup.CYPHER, null, true);
        }

        public static Suggestion command(Command.Metadata command) {
            return new Suggestion(command.name(), SuggestionGroup.COMMAND, command.description(), true);
        }

        public static Suggestion identifier(String identifier) {
            return new Suggestion(identifier, SuggestionGroup.IDENTIFIER, null, false);
        }

        public static Suggestion parameter(String parameterName) {
            return new Suggestion("$" + parameterName, SuggestionGroup.PARAMETER, null, true);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum SuggestionGroup {
        COMMAND("Commands"),
        IDENTIFIER("Query Identifiers"),
        PARAMETER("Query Parameters"),
        CYPHER("Query Syntax Suggestions (not complete)");

        private final String groupName;

        private SuggestionGroup(String groupName) {
            this.groupName = groupName;
        }
    }
}

