/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import org.neo4j.shell.Connector;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.util.Versions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record UserMessagesHandler(Connector connector) {
    public String getWelcomeMessage() {
        AnsiFormattedText message = AnsiFormattedText.from("Connected to Neo4j");
        String protocolVersion = this.connector.getProtocolVersion();
        if (!protocolVersion.isEmpty()) {
            String versionString;
            try {
                versionString = Versions.version(protocolVersion).majorMinorString();
            }
            catch (Versions.FailedToParseException e) {
                versionString = protocolVersion;
            }
            message.append(" using Bolt protocol version " + versionString);
        }
        message.append(" at ").bold(this.connector.connectionConfig().uri().toString());
        if (!this.connector.username().isEmpty()) {
            message.append(" as user ").bold(this.connector.username());
        }
        this.connector.impersonatedUser().ifPresent(impersonated -> message.orange(" impersonating ").bold((String)impersonated));
        return message.append(".\nType ").bold(":help").append(" for a list of available commands or ").bold(":exit").append(" to exit the shell.").append("\nNote that Cypher queries must end with a ").bold("semicolon.").resetAndRender();
    }

    public static String getExitMessage() {
        return "\nBye!";
    }
}

