/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.timeout;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.shell.timeout.IdleTimeoutService;
import org.neo4j.util.VisibleForTesting;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class IdleTimeoutServiceImpl
implements IdleTimeoutService {
    private static final long DEFAULT_SIGNIFICANT_DURATION_NS = TimeUnit.SECONDS.toNanos(10L);
    private final AtomicLong lastSeenNs;
    private final AtomicBoolean paused = new AtomicBoolean(true);
    private final long timeoutNs;
    private final Ticker ticker;
    private final ScheduledExecutorService timeoutExecutor;
    private final Runnable timeoutAction;
    private final Runnable wakeUpAction;
    private final long significantDurationNs;

    IdleTimeoutServiceImpl(Duration timeout, Duration delay, Runnable timeoutAction, Runnable wakeUpAction) {
        this(System::nanoTime, timeout, timeout, delay, timeoutAction, wakeUpAction);
    }

    @VisibleForTesting
    IdleTimeoutServiceImpl(Ticker ticker, Duration timeout, Duration initialDelay, Duration delay, Runnable timeoutAction, Runnable wakeUpAction) {
        long actualDelayMs = IdleTimeoutServiceImpl.calculateDelayMs(timeout.toMillis(), delay.toMillis());
        this.ticker = ticker;
        this.timeoutNs = timeout.toNanos();
        this.timeoutAction = timeoutAction;
        this.wakeUpAction = wakeUpAction;
        this.lastSeenNs = new AtomicLong(ticker.get());
        this.significantDurationNs = this.timeoutNs > 10L * DEFAULT_SIGNIFICANT_DURATION_NS ? DEFAULT_SIGNIFICANT_DURATION_NS : 0L;
        this.timeoutExecutor = Executors.newSingleThreadScheduledExecutor();
        this.timeoutExecutor.scheduleWithFixedDelay(this::callIdleTimeoutAction, initialDelay.toMillis(), actualDelayMs, TimeUnit.MILLISECONDS);
    }

    private static long calculateDelayMs(long timeoutMs, long delayMs) {
        long timeoutDividedByFour = timeoutMs / 4L;
        if (delayMs <= timeoutDividedByFour) {
            return delayMs;
        }
        int minDelayMs = 1000;
        return Math.max(1000L, timeoutDividedByFour);
    }

    @Override
    public void pause() {
        this.paused.set(true);
    }

    @Override
    public void resume() {
        this.lastSeenNs.set(this.ticker.get());
        this.paused.set(false);
    }

    @Override
    public void imAwake() {
        if (!this.paused.get() && this.elapsed() > this.significantDurationNs) {
            this.lastSeenNs.set(this.ticker.get());
            if (this.wakeUpAction != null) {
                this.wakeUpAction.run();
            }
        }
    }

    private void callIdleTimeoutAction() {
        if (!this.paused.get() && this.elapsed() > this.timeoutNs && this.timeoutAction != null && !this.paused.get()) {
            this.timeoutAction.run();
        }
    }

    private long elapsed() {
        return this.ticker.get() - this.lastSeenNs.get();
    }

    @Override
    public void close() {
        this.timeoutExecutor.shutdownNow();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface Ticker {
        public long get();
    }
}

