/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.util.Map;
import java.util.function.Consumer;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OnceArgumentAction
implements ArgumentAction {
    public void run(ArgumentParser parser, Argument arg, Map<String, Object> attrs, String flag, Object value) throws ArgumentParserException {
        this.run(parser, arg, attrs, flag, value, v -> attrs.put(arg.getDest(), v));
    }

    public void run(ArgumentParser parser, Argument arg, Map<String, Object> attrs, String flag, Object value, Consumer<Object> valueSetter) throws ArgumentParserException {
        String seenAttr = this.getClass().getName() + ".seen::" + arg.getDest();
        if (attrs.get(seenAttr) == Boolean.TRUE) {
            throw new ArgumentParserException("Specify one of " + arg.textualName(), parser);
        }
        attrs.put(seenAttr, true);
        valueSetter.accept(value);
    }

    public boolean consumeArgument() {
        return true;
    }

    public void onAttach(Argument arg) {
    }
}

