/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.value.NumberValueAdapter;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.OutputFormatter;
import org.neo4j.shell.prettyprint.TablePlanFormatter;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.shell.util.Versions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TableOutputFormatter
implements OutputFormatter {
    public static final String STRING_REPRESENTATION = "string-representation";
    private final boolean wrap;
    private final int numSampleRows;

    public TableOutputFormatter(boolean wrap, int numSampleRows) {
        this.wrap = wrap;
        this.numSampleRows = numSampleRows;
    }

    @Override
    public int formatAndCount(BoltResult result, LinePrinter output) {
        String[] columns = result.getKeys().toArray(new String[0]);
        if (columns.length == 0) {
            return 0;
        }
        Iterator<Record> records = result.iterate();
        return this.formatResultAndCountRows(columns, records, output);
    }

    public void formatWithHeading(BoltResult result, LinePrinter output, String heading) {
        String[] columns = result.getKeys().toArray(new String[0]);
        this.printTableAndCountRows(columns, Collections.emptyIterator(), output, result.getRecords(), true, heading);
    }

    private static void take(Iterator<Record> records, ArrayList<Record> topRecords, int count) {
        while (records.hasNext() && topRecords.size() < count) {
            topRecords.add(records.next());
        }
    }

    private int formatResultAndCountRows(String[] columns, Iterator<Record> records, LinePrinter output) {
        ArrayList<Record> topRecords = new ArrayList<Record>(this.numSampleRows);
        try {
            TableOutputFormatter.take(records, topRecords, this.numSampleRows);
        }
        catch (RuntimeException e) {
            this.printTableAndCountRows(columns, records, output, topRecords, false, null);
            throw e;
        }
        return this.printTableAndCountRows(columns, records, output, topRecords, true, null);
    }

    private int printTableAndCountRows(String[] columns, Iterator<Record> records, LinePrinter output, List<Record> topRecords, boolean printFooter, String heading) {
        int[] columnSizes = this.calculateColumnSizes(columns, topRecords, records.hasNext(), heading);
        int totalWidth = 1;
        for (int columnSize : columnSizes) {
            totalWidth += columnSize + 3;
        }
        StringBuilder builder = new StringBuilder(totalWidth);
        int lineWidth = totalWidth - 2;
        String dashes = "+" + String.valueOf(OutputFormatter.repeat('-', lineWidth)) + "+";
        if (heading != null && !heading.isBlank()) {
            output.printOut(dashes);
            output.printOut(this.formatRow(builder, new int[]{lineWidth - 2}, new String[]{heading}, new boolean[]{false}));
            builder.setLength(0);
        }
        output.printOut(dashes);
        output.printOut(this.formatRow(builder, columnSizes, columns, new boolean[columnSizes.length]));
        output.printOut(dashes);
        int numberOfRows = 0;
        for (Record record : topRecords) {
            output.printOut(this.formatRecord(builder, columnSizes, record));
            ++numberOfRows;
        }
        while (records.hasNext()) {
            output.printOut(this.formatRecord(builder, columnSizes, records.next()));
            ++numberOfRows;
        }
        if (printFooter) {
            output.printOut(String.format("%s%n", dashes));
        }
        return numberOfRows;
    }

    private int[] calculateColumnSizes(String[] columns, List<Record> data, boolean moreDataAfterSamples, String heading) {
        int[] columnSizes = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnSizes[i] = columns[i].length();
        }
        for (Record record : data) {
            for (int i = 0; i < columns.length; ++i) {
                int len = this.columnLengthForValue(record.get(i), moreDataAfterSamples);
                if (columnSizes[i] >= len) continue;
                columnSizes[i] = len;
            }
        }
        if (heading != null) {
            int totalSize = Arrays.stream(columnSizes).sum();
            if (heading.length() > totalSize) {
                columnSizes[0] = columnSizes[0] + (heading.length() - totalSize);
            }
        }
        return columnSizes;
    }

    private int columnLengthForValue(Value value, boolean moreDataAfterSamples) {
        if (value instanceof NumberValueAdapter && moreDataAfterSamples) {
            return 19;
        }
        return this.formatValue(value).length();
    }

    private String formatRecord(StringBuilder sb, int[] columnSizes, Record record) {
        sb.setLength(0);
        return this.formatRow(sb, columnSizes, this.formatValues(record), new boolean[columnSizes.length]);
    }

    private String[] formatValues(Record record) {
        String[] row = new String[record.size()];
        for (int i = 0; i < row.length; ++i) {
            row[i] = this.formatValue(record.get(i));
        }
        return row;
    }

    private String formatRow(StringBuilder sb, int[] columnSizes, String[] row, boolean[] continuation) {
        if (!continuation[0]) {
            sb.append("|");
        } else {
            sb.append("\\");
        }
        boolean remainder = false;
        for (int i = 0; i < row.length; ++i) {
            sb.append(" ");
            int length = columnSizes[i];
            String txt = row[i];
            if (txt != null) {
                int codepoint;
                int codePointCount;
                int offset = 0;
                for (codePointCount = 0; codePointCount < length && offset < txt.length() && (codepoint = txt.codePointAt(offset)) != 10 && codepoint != 13; ++codePointCount) {
                    sb.appendCodePoint(codepoint);
                    offset = txt.offsetByCodePoints(offset, 1);
                }
                if (offset < txt.length()) {
                    if (this.wrap) {
                        row[i] = txt.substring(TableOutputFormatter.nextLineStart(txt, offset));
                        continuation[i] = true;
                        remainder = true;
                    } else if (codePointCount < length) {
                        sb.append("\u2026");
                        ++codePointCount;
                    } else {
                        int lastCodePoint = sb.codePointBefore(sb.length());
                        int lastLength = Character.charCount(lastCodePoint);
                        sb.replace(sb.length() - lastLength, sb.length(), "\u2026");
                    }
                } else {
                    row[i] = null;
                }
                if (codePointCount < length) {
                    sb.append(OutputFormatter.repeat(' ', length - codePointCount));
                }
            } else {
                sb.append(OutputFormatter.repeat(' ', length));
            }
            if (i == row.length - 1 || !continuation[i + 1]) {
                sb.append(" |");
                continue;
            }
            sb.append(" \\");
        }
        if (this.wrap && remainder) {
            sb.append(OutputFormatter.NEWLINE);
            this.formatRow(sb, columnSizes, row, continuation);
        }
        return sb.toString();
    }

    private static int nextLineStart(String txt, int start) {
        if (start < txt.length()) {
            char firstChar = txt.charAt(start);
            if (firstChar == '\n') {
                return start + 1;
            }
            if (firstChar == '\r') {
                int next = start + 1;
                if (next < txt.length() && txt.charAt(next) == '\n') {
                    return next + 1;
                }
                return start + 1;
            }
            return start;
        }
        return txt.length();
    }

    @Override
    public String formatFooter(BoltResult result, int numberOfRows) {
        ResultSummary summary = result.getSummary();
        return String.format("%d row%s" + OutputFormatter.NEWLINE + "ready to start consuming query after %d ms, results consumed after another %d ms", numberOfRows, numberOfRows != 1 ? "s" : "", summary.resultAvailableAfter(TimeUnit.MILLISECONDS), summary.resultConsumedAfter(TimeUnit.MILLISECONDS));
    }

    @Override
    public String formatNotifications(List<Notification> notifications, String protocolVersion) {
        boolean legacyVersion;
        if (notifications.isEmpty()) {
            return "";
        }
        HashSet<String> messages = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        try {
            legacyVersion = Versions.version(protocolVersion).compareTo(Versions.version("5.6")) < 0;
        }
        catch (AssertionError e) {
            legacyVersion = true;
        }
        for (Notification notification : notifications) {
            String message = this.formatNotification(notification, legacyVersion);
            if (!messages.add(message)) continue;
            builder.append('\n').append(message).append('\n');
        }
        return builder.toString();
    }

    private String formatNotification(Notification notification, boolean legacyFormat) {
        String severity = TableOutputFormatter.severityString(notification);
        if (legacyFormat) {
            return String.format("%s: %s (%s)", severity, notification.description(), notification.code());
        }
        return String.format("%s: %s%n%s (%s)", severity, notification.description(), notification.gqlStatus(), notification.code());
    }

    private static String severityString(Notification notification) {
        String rawSeverity;
        return switch (rawSeverity = notification.rawSeverityLevel().orElse("information").toLowerCase(Locale.ROOT)) {
            case "information" -> "info";
            case "warning" -> "warn";
            default -> rawSeverity;
        };
    }

    @Override
    public String formatInfo(ResultSummary summary) {
        Map<String, Value> info = OutputFormatter.info(summary);
        if (info.isEmpty()) {
            return "";
        }
        String[] columns = info.keySet().toArray(new String[0]);
        StringBuilder sb = new StringBuilder();
        InternalRecord record = new InternalRecord(Arrays.asList(columns), info.values().toArray(new Value[0]));
        this.formatResultAndCountRows(columns, Collections.singletonList(record).iterator(), line -> sb.append(line).append(OutputFormatter.NEWLINE));
        return sb.toString();
    }

    @Override
    public String formatPlan(ResultSummary summary) {
        if (summary == null || !summary.hasPlan()) {
            return "";
        }
        Plan plan = summary.plan();
        if (plan.arguments().containsKey(STRING_REPRESENTATION)) {
            return ((Value)plan.arguments().get(STRING_REPRESENTATION)).asString();
        }
        return new TablePlanFormatter().formatPlan(plan);
    }

    @Override
    public Set<OutputFormatter.Capabilities> capabilities() {
        return EnumSet.allOf(OutputFormatter.Capabilities.class);
    }
}

