/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.io.IOException;
import java.util.List;
import org.neo4j.shell.Historian;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class History
implements Command {
    private final Printer printer;
    private final Historian historian;

    public History(Printer printer, Historian historian) {
        this.printer = printer;
        this.historian = historian;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 0, 1);
        if (args.size() == 1) {
            if (!"clear".equalsIgnoreCase(args.get(0))) throw new CommandException("Unrecognised argument " + args.get(0));
            this.clearHistory();
            return;
        } else {
            int lineCount = 16;
            this.printer.printOut(History.printHistory(this.historian.getHistory(), lineCount));
        }
    }

    private static String printHistory(List<String> history, int lineCount) {
        int colWidth = Integer.toString(history.size()).length();
        String firstLineFormat = " %-" + colWidth + "d  %s%n";
        String continuationLineFormat = " %-" + colWidth + "s  %s%n";
        StringBuilder builder = new StringBuilder();
        for (int i = Math.max(0, history.size() - lineCount); i < history.size(); ++i) {
            String statement = history.get(i);
            String[] lines = statement.split("\\r?\\n");
            builder.append(String.format(firstLineFormat, i + 1, lines[0]));
            for (int l = 1; l < lines.length; ++l) {
                builder.append(String.format(continuationLineFormat, " ", lines[l]));
            }
        }
        return builder.toString();
    }

    private void clearHistory() throws CommandException {
        try {
            this.printer.printIfVerbose("Removing history...");
            this.historian.clear();
        }
        catch (IOException e) {
            throw new CommandException("Failed to clear history: " + e.getMessage());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "':history' prints a list of the last statements executed\n':history clear' removes all entries from the history";
            return new Command.Metadata(":history", "Statement history", "", help, List.of());
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new History(args.printer(), args.historian());
        }
    }
}

