/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.timeout;

import java.time.Duration;
import org.neo4j.shell.timeout.IdleTimeoutServiceImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface IdleTimeoutService
extends AutoCloseable {
    public void imAwake();

    public void pause();

    public void resume();

    public static IdleTimeoutService create(Duration idleTimeout, Duration delay) {
        if (idleTimeout != null && !idleTimeout.isZero() && !idleTimeout.isNegative()) {
            return new IdleTimeoutServiceImpl(idleTimeout, delay);
        }
        return IdleTimeoutService.noTimeout();
    }

    public static IdleTimeoutService noTimeout() {
        return new IdleTimeoutService(){

            @Override
            public void imAwake() {
            }

            @Override
            public void pause() {
            }

            @Override
            public void resume() {
            }

            @Override
            public void close() {
            }
        };
    }
}

