/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.startup;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.neo4j.shell.Main;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CypherShellBoot {
    public static void main(String[] args) throws IOException, InterruptedException {
        int exitCode;
        CypherShellBoot.jvmCheck();
        ProcessBuilder processBuilder = new ProcessBuilder(CypherShellBoot.command(args));
        processBuilder.inheritIO();
        processBuilder.environment().putAll(CypherShellBoot.environment());
        Process process = null;
        try {
            process = processBuilder.start();
            exitCode = process.waitFor();
        }
        catch (Exception e) {
            if (process != null) {
                process.destroy();
            }
            throw e;
        }
        System.exit(exitCode);
    }

    private static void jvmCheck() {
        if (Runtime.version().feature() < 17) {
            System.err.println("You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 17 or OpenJDK(TM) 17.");
        }
    }

    private static List<String> command(String[] args) {
        String javaCommand = ProcessHandle.current().info().command().orElseThrow(() -> new IllegalStateException("Wasn't able to figure out java binary"));
        String classPath = System.getProperty("app.home") + File.separator + "lib" + File.separator + "*";
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaCommand);
        command.addAll(CypherShellBoot.jvmInputArguments());
        command.add("-cp");
        command.add(classPath);
        command.add(Main.class.getName());
        command.addAll(Arrays.asList(args));
        return command;
    }

    private static Map<String, String> environment() {
        if (System.getenv() == null) {
            return Map.of();
        }
        return System.getenv();
    }

    private static List<String> jvmInputArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        arguments.addAll(CypherShellBoot.extraJvmArguments());
        return arguments;
    }

    private static List<String> extraJvmArguments() {
        return List.of("--add-opens", "java.base/java.net=ALL-UNNAMED", "--add-opens", "java.base/java.lang=ALL-UNNAMED", "--add-opens", "java.base/java.nio=ALL-UNNAMED");
    }
}

