/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.fusesource.jansi.internal.CLibrary;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.Historian;
import org.neo4j.shell.UserMessagesHandler;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.InteractiveShellRunner;
import org.neo4j.shell.cli.NonInteractiveShellRunner;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.ShellStatementParser;
import org.neo4j.shell.system.Utils;
import org.neo4j.shell.terminal.CypherShellTerminal;

public interface ShellRunner {
    public static final int STDIN_FILENO = 0;
    public static final int STDOUT_FILENO = 1;

    public static boolean shouldBeInteractive(CliArgs cliArgs, boolean isInputInteractive) {
        return !cliArgs.getNonInteractive() && cliArgs.getInputFilename() == null && isInputInteractive;
    }

    public static boolean isInputInteractive() {
        if (Utils.isWindows()) {
            return System.console() != null;
        }
        try {
            return 1 == CLibrary.isatty((int)0);
        }
        catch (Throwable ignored) {
            return System.console() != null;
        }
    }

    public static boolean isOutputInteractive() {
        if (Utils.isWindows()) {
            return System.console() != null;
        }
        try {
            return 1 == CLibrary.isatty((int)1);
        }
        catch (Throwable ignored) {
            return System.console() != null;
        }
    }

    public static InputStream getInputStream(CliArgs cliArgs) throws FileNotFoundException {
        if (cliArgs.getInputFilename() == null) {
            return System.in;
        }
        return new BufferedInputStream(new FileInputStream(new File(cliArgs.getInputFilename())));
    }

    public int runUntilEnd();

    public Historian getHistorian();

    public static class Factory {
        public ShellRunner create(CliArgs cliArgs, CypherShell shell, Logger logger, ConnectionConfig connectionConfig, CypherShellTerminal terminal) throws IOException {
            if (ShellRunner.shouldBeInteractive(cliArgs, terminal.isInteractive())) {
                UserMessagesHandler userMessagesHandler = new UserMessagesHandler(connectionConfig, shell.getProtocolVersion());
                return new InteractiveShellRunner(shell, shell, shell, shell, logger, terminal, userMessagesHandler, connectionConfig, cliArgs.getHistoryFile());
            }
            return new NonInteractiveShellRunner(cliArgs.getFailBehavior(), shell, logger, new ShellStatementParser(), ShellRunner.getInputStream(cliArgs));
        }
    }
}

