/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.prettyprint.CypherVariablesFormatter;

public class Params
implements Command {
    public static final String COMMAND_NAME = ":params";
    private static final Pattern backtickPattern = Pattern.compile("^\\s*(?<key>(`([^`])*`)+?)\\s*");
    private final Logger logger;
    private final ParameterService parameters;

    public Params(Logger logger, ParameterService parameters) {
        this.logger = logger;
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDescription() {
        return "Print all currently set query parameters and their values";
    }

    @Override
    public String getUsage() {
        return "[parameter]";
    }

    @Override
    public String getHelp() {
        return "Print a table of all currently set query parameters or the value for the given parameter";
    }

    @Override
    public List<String> getAliases() {
        return Arrays.asList(":parameters");
    }

    @Override
    public void execute(String argString) throws ExitException, CommandException {
        String trim = argString.trim();
        Matcher matcher = backtickPattern.matcher(trim);
        if (trim.startsWith("`") && matcher.matches()) {
            this.listParam(trim);
        } else {
            String[] args = CommandHelper.simpleArgParse(argString, 0, 1, COMMAND_NAME, this.getUsage());
            if (args.length > 0) {
                this.listParam(args[0]);
            } else {
                this.listAllParams();
            }
        }
    }

    private void listParam(String name) throws CommandException {
        String parameterName = CypherVariablesFormatter.unescapedCypherVariable(name);
        ParameterService.Parameter param = this.parameters.parameters().get(parameterName);
        if (param == null) {
            throw new CommandException("Unknown parameter: " + name);
        }
        this.listParam(name.length(), name, param.expressionString);
    }

    private void listParam(int leftColWidth, String key, Object value) {
        this.logger.printOut(String.format(":param %-" + leftColWidth + "s => %s", key, value));
    }

    private void listAllParams() {
        List<Map.Entry> sortedParams = this.parameters.parameters().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> Map.entry(CypherVariablesFormatter.escape((String)e.getKey()), (ParameterService.Parameter)e.getValue())).collect(Collectors.toList());
        int width = sortedParams.stream().map(e -> ((String)e.getKey()).length()).reduce(0, Math::max);
        sortedParams.forEach(e -> this.listParam(width, (String)e.getKey(), ((ParameterService.Parameter)e.getValue()).expressionString));
    }
}

