/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.util;

import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.shell.util.Version;

public final class Versions {
    private Versions() {
        throw new UnsupportedOperationException("Don't instantiate");
    }

    public static int majorVersion(String version) {
        return Versions.version(version).major();
    }

    public static int minorVersion(String version) {
        return Versions.version(version).minor();
    }

    public static int patch(String version) {
        return Versions.version(version).patch();
    }

    public static Version version(String version) {
        if (version == null) {
            throw new AssertionError((Object)"null is not a valid version string");
        }
        if (version.isEmpty()) {
            return new Version(0, 0, 0);
        }
        int offset = version.indexOf("-");
        if (offset > 0) {
            version = version.substring(0, offset);
        }
        String[] split = version.split("\\.");
        switch (split.length) {
            case 1: {
                return new Version(Integer.parseInt(split[0]), 0, 0);
            }
            case 2: {
                return new Version(Integer.parseInt(split[0]), Integer.parseInt(split[1]), 0);
            }
            case 3: {
                return new Version(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            }
        }
        throw new AssertionError((Object)String.format("%s is not a proper version string, it should be of the form X.Y.Z ", version));
    }

    public static boolean isPasswordChangeRequiredException(Neo4jException e) {
        return "Neo.ClientError.Security.CredentialsExpired".equalsIgnoreCase(e.code());
    }
}

