/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.value.NumberValueAdapter;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.OutputFormatter;
import org.neo4j.shell.prettyprint.TablePlanFormatter;
import org.neo4j.shell.state.BoltResult;

public class TableOutputFormatter
implements OutputFormatter {
    private final boolean wrap;
    private final int numSampleRows;

    public TableOutputFormatter(boolean wrap, int numSampleRows) {
        this.wrap = wrap;
        this.numSampleRows = numSampleRows;
    }

    @Override
    public int formatAndCount(BoltResult result, LinePrinter output) {
        String[] columns = result.getKeys().toArray(new String[0]);
        if (columns.length == 0) {
            return 0;
        }
        Iterator<Record> records = result.iterate();
        return this.formatResultAndCountRows(columns, records, output);
    }

    private static List<Record> take(Iterator<Record> records, int count) {
        ArrayList<Record> topRecords = new ArrayList<Record>(count);
        while (records.hasNext() && topRecords.size() < count) {
            topRecords.add(records.next());
        }
        return topRecords;
    }

    private int formatResultAndCountRows(String[] columns, Iterator<Record> records, LinePrinter output) {
        List<Record> topRecords = TableOutputFormatter.take(records, this.numSampleRows);
        int[] columnSizes = this.calculateColumnSizes(columns, topRecords, records.hasNext());
        int totalWidth = 1;
        for (int columnSize : columnSizes) {
            totalWidth += columnSize + 3;
        }
        StringBuilder builder = new StringBuilder(totalWidth);
        String headerLine = this.formatRow(builder, columnSizes, columns, new boolean[columnSizes.length]);
        int lineWidth = totalWidth - 2;
        String dashes = "+" + OutputFormatter.repeat('-', lineWidth) + "+";
        output.printOut(dashes);
        output.printOut(headerLine);
        output.printOut(dashes);
        int numberOfRows = 0;
        for (Record record : topRecords) {
            output.printOut(this.formatRecord(builder, columnSizes, record));
            ++numberOfRows;
        }
        while (records.hasNext()) {
            output.printOut(this.formatRecord(builder, columnSizes, records.next()));
            ++numberOfRows;
        }
        output.printOut(String.format("%s%n", dashes));
        return numberOfRows;
    }

    private int[] calculateColumnSizes(String[] columns, List<Record> data, boolean moreDataAfterSamples) {
        int[] columnSizes = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnSizes[i] = columns[i].length();
        }
        for (Record record : data) {
            for (int i = 0; i < columns.length; ++i) {
                int len = this.columnLengthForValue(record.get(i), moreDataAfterSamples);
                if (columnSizes[i] >= len) continue;
                columnSizes[i] = len;
            }
        }
        return columnSizes;
    }

    private int columnLengthForValue(Value value, boolean moreDataAfterSamples) {
        if (value instanceof NumberValueAdapter && moreDataAfterSamples) {
            return 19;
        }
        return this.formatValue(value).length();
    }

    private String formatRecord(StringBuilder sb, int[] columnSizes, Record record) {
        sb.setLength(0);
        return this.formatRow(sb, columnSizes, this.formatValues(record), new boolean[columnSizes.length]);
    }

    private String[] formatValues(Record record) {
        String[] row = new String[record.size()];
        for (int i = 0; i < row.length; ++i) {
            row[i] = this.formatValue(record.get(i));
        }
        return row;
    }

    private String formatRow(StringBuilder sb, int[] columnSizes, String[] row, boolean[] continuation) {
        if (!continuation[0]) {
            sb.append("|");
        } else {
            sb.append("\\");
        }
        boolean remainder = false;
        for (int i = 0; i < row.length; ++i) {
            sb.append(" ");
            int length = columnSizes[i];
            String txt = row[i];
            if (txt != null) {
                if (txt.length() > length) {
                    if (this.wrap) {
                        sb.append(txt, 0, length);
                        row[i] = txt.substring(length);
                        continuation[i] = true;
                        remainder = true;
                    } else {
                        sb.append(txt, 0, length - 1);
                        sb.append("\u2026");
                    }
                } else {
                    row[i] = null;
                    sb.append(OutputFormatter.rightPad(txt, length));
                }
            } else {
                sb.append(OutputFormatter.repeat(' ', length));
            }
            if (i == row.length - 1 || !continuation[i + 1]) {
                sb.append(" |");
                continue;
            }
            sb.append(" \\");
        }
        if (this.wrap && remainder) {
            sb.append(OutputFormatter.NEWLINE);
            this.formatRow(sb, columnSizes, row, continuation);
        }
        return sb.toString();
    }

    @Override
    public String formatFooter(BoltResult result, int numberOfRows) {
        ResultSummary summary = result.getSummary();
        return String.format("%d row%s" + OutputFormatter.NEWLINE + "ready to start consuming query after %d ms, results consumed after another %d ms", numberOfRows, numberOfRows != 1 ? "s" : "", summary.resultAvailableAfter(TimeUnit.MILLISECONDS), summary.resultConsumedAfter(TimeUnit.MILLISECONDS));
    }

    @Override
    public String formatInfo(ResultSummary summary) {
        Map<String, Value> info = OutputFormatter.info(summary);
        if (info.isEmpty()) {
            return "";
        }
        String[] columns = info.keySet().toArray(new String[0]);
        StringBuilder sb = new StringBuilder();
        InternalRecord record = new InternalRecord(Arrays.asList(columns), info.values().toArray(new Value[0]));
        this.formatResultAndCountRows(columns, Collections.singletonList(record).iterator(), line -> sb.append(line).append(OutputFormatter.NEWLINE));
        return sb.toString();
    }

    @Override
    public String formatPlan(ResultSummary summary) {
        if (summary == null || !summary.hasPlan()) {
            return "";
        }
        return new TablePlanFormatter().formatPlan(summary.plan());
    }

    @Override
    public Set<OutputFormatter.Capabilities> capabilities() {
        return EnumSet.allOf(OutputFormatter.Capabilities.class);
    }
}

