/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.util;

import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.exception.ParameterException;

public abstract class ParameterSetter<E extends Exception> {
    private static final Pattern backtickPattern = Pattern.compile("^\\s*(?<key>(`([^`])*`)+?):?\\s+(?<value>.+)$");
    private static final Pattern backtickLambdaPattern = Pattern.compile("^\\s*(?<key>(`([^`])*`)+?)\\s*=>\\s*(?<value>.+)$");
    private static final Pattern argPattern = Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*):?\\s+(?<value>.+)$");
    private static final Pattern lambdaPattern = Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*)\\s*=>\\s*(?<value>.+)$");
    private static final Pattern lambdaMapPattern = Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*):\\s*=>\\s*(?<value>.+)$");
    private final ParameterMap parameterMap;

    protected ParameterSetter(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    protected abstract void onWrongUsage() throws E;

    protected abstract void onWrongNumberOfArguments() throws E;

    protected abstract void onParameterException(ParameterException var1) throws E;

    public void execute(@Nonnull String argString) throws E {
        Matcher lambdaMapMatcher = lambdaMapPattern.matcher(argString);
        if (lambdaMapMatcher.matches()) {
            this.onWrongUsage();
        }
        try {
            if (!this.assignIfValidParameter(argString)) {
                this.onWrongNumberOfArguments();
            }
        }
        catch (ParameterException e) {
            this.onParameterException(e);
        }
    }

    private boolean assignIfValidParameter(@Nonnull String argString) throws ParameterException {
        return this.setParameterIfItMatchesPattern(argString, lambdaPattern, this.assignIfValidParameter()) || this.setParameterIfItMatchesPattern(argString, argPattern, this.assignIfValidParameter()) || this.setParameterIfItMatchesPattern(argString, backtickLambdaPattern, this.backTickMatchPattern()) || this.setParameterIfItMatchesPattern(argString, backtickPattern, this.backTickMatchPattern());
    }

    private boolean setParameterIfItMatchesPattern(@Nonnull String argString, Pattern pattern, BiPredicate<String, Matcher> matchingFunction) throws ParameterException {
        Matcher matcher = pattern.matcher(argString);
        if (matchingFunction.test(argString, matcher)) {
            this.parameterMap.setParameter(matcher.group("key"), matcher.group("value"));
            return true;
        }
        return false;
    }

    private BiPredicate<String, Matcher> assignIfValidParameter() {
        return (argString, matcher) -> matcher.matches();
    }

    private BiPredicate<String, Matcher> backTickMatchPattern() {
        return (argString, backtickLambdaMatcher) -> argString.trim().startsWith("`") && backtickLambdaMatcher.matches() && backtickLambdaMatcher.group("key").length() > 2;
    }
}

