/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;

public class Begin
implements Command {
    private static final String COMMAND_NAME = ":begin";
    private final TransactionHandler transactionHandler;

    public Begin(@Nonnull TransactionHandler transactionHandler) {
        this.transactionHandler = transactionHandler;
    }

    @Override
    @Nonnull
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Open a transaction";
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "";
    }

    @Override
    @Nonnull
    public String getHelp() {
        return String.format("Start a transaction which will remain open until %s or %s is called", ":commit", ":rollback");
    }

    @Override
    @Nonnull
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    public void execute(@Nonnull String argString) throws ExitException, CommandException {
        CommandHelper.simpleArgParse(argString, 0, COMMAND_NAME, this.getUsage());
        this.transactionHandler.beginTransaction();
    }
}

