/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import javax.annotation.Nonnull;
import org.neo4j.shell.cli.Encryption;

public class ConnectionConfig {
    public static final String USERNAME_ENV_VAR = "NEO4J_USERNAME";
    public static final String PASSWORD_ENV_VAR = "NEO4J_PASSWORD";
    public static final String DATABASE_ENV_VAR = "NEO4J_DATABASE";
    private final String scheme;
    private final String host;
    private final int port;
    private final Encryption encryption;
    private String username;
    private String password;
    private String newPassword;
    private String database;

    public ConnectionConfig(@Nonnull String scheme, @Nonnull String host, int port, @Nonnull String username, @Nonnull String password, Encryption encryption, @Nonnull String database) {
        this.host = host;
        this.port = port;
        this.username = ConnectionConfig.fallbackToEnvVariable(username, USERNAME_ENV_VAR);
        this.password = ConnectionConfig.fallbackToEnvVariable(password, PASSWORD_ENV_VAR);
        this.encryption = encryption;
        this.scheme = scheme;
        this.database = ConnectionConfig.fallbackToEnvVariable(database, DATABASE_ENV_VAR);
    }

    @Nonnull
    private static String fallbackToEnvVariable(@Nonnull String preferredValue, @Nonnull String fallbackEnvVar) {
        String result = System.getenv(fallbackEnvVar);
        if (result == null || !preferredValue.isEmpty()) {
            result = preferredValue;
        }
        return result;
    }

    @Nonnull
    public String scheme() {
        return this.scheme;
    }

    @Nonnull
    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    @Nonnull
    public String username() {
        return this.username;
    }

    @Nonnull
    public String password() {
        return this.password;
    }

    public String newPassword() {
        return this.newPassword;
    }

    @Nonnull
    public String driverUrl() {
        return String.format("%s://%s:%d", this.scheme(), this.host(), this.port());
    }

    @Nonnull
    public Encryption encryption() {
        return this.encryption;
    }

    @Nonnull
    public String database() {
        return this.database;
    }

    public void setUsername(@Nonnull String username) {
        this.username = username;
    }

    public void setPassword(@Nonnull String password) {
        this.password = password;
    }

    public void setNewPassword(String password) {
        this.newPassword = password;
    }

    public boolean passwordChangeRequired() {
        return this.newPassword != null;
    }
}

